function vizier_phot_xml,xml_file
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read SED data as VOT table downloaded from:
; http://vizier.cds.unistra.fr/vizier/sed/
;
if n_elements(xml_file) eq 0 then xml_file='HD217014.vot'
;
phot_struct_xml=read_votable[xml_file]
;
; help,phot_struct_xml
;* Structure <27ea898>, 10 tags, length=62784, data length=62784, refs=1:
;  _RAJ2000        DOUBLE    Array[654]
;  _DEJ2000        DOUBLE    Array[654]
;  _TABNAME        STRING    Array[654]
;  _ID             STRING    Array[654]
;  _TIME           DOUBLE    Array[654]
;  _ETIME          DOUBLE    Array[654]
;  _SED_FREQ       DOUBLE    Array[654]
;  _SED_FLUX       FLOAT     Array[654]
;  _SED_EFLUX      FLOAT     Array[654]
;  _SED_FILTER     STRING    Array[654]
;
; Extract data
unid=phot_struct_xml._ID
wave=3.0e5/phot_struct_xml._SED_FREQ
flux=phot_struct_xml._SED_FLUX
fnan=finite(phot_struct_xml._SED_EFLUX)
ferr=phot_struct_xml._SED_EFLUX
filt=phot_struct_xml._SED_FILTER
;
index=where(fnan eq 0)
fnan[index]=1
; Remove these entries
index=where(fnan ne 0)
l=l[index]
unid=unid[index]
wave=wave[index]
flux=flux[index]
ferr=ferr[index]
filt=filt[index]
;
; Use higher quality measurements
index=where(ferr gt 0 and abs(ferr) lt 1e-7,count)
l=l[index]
unid=unid[index]
wave=wave[index]
flux=flux[index]
ferr=ferr[index]
filt=filt[index]
;
; Many records are duplicates
index=uniq(unid,sort(unid))
l=l[index]
wave=wave[index]
flux=flux[index]
ferr=ferr[index]
filt=filt[index]
;
; Write SED data
sed_file=star+'.txt'
openw,unit,sed_file,/get_lun
for i=0,n_elements(l)-1 do printf,unit,l[i]
free_lun,unit
;
index=sort(wave)
return,{wave:wave,flux:flux,ferr:ferr,filt:filt}
;
end
