function vizier_starid,starids
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This function is called to enable Vizier access for OYSTER StarIds which
; do not conform to the SimBad naming convention, e.g. HDN123456 -> HD123456
;
; Remove white space
for i=0l,n_elements(starids)-1 do begin
	ok=1
	case strmid(starids[i],0,3) of
	'HDN': ok=0
	'HIP': ok=0
	'HIC': ok=0
	'BSC': ok=0
	'FKV': ok=0
	else:
	endcase
	if not ok then begin
	ID=string(strmid(strcompress(starids,/remove_all),3,6),format='(i6.6)')
	case strmid(starids[i],0,3) of
;	'HDN': starids(i)='HD'+string(strmid(starids(i),3,6),format='(i6.6)')
;	'HIP': starids(i)='HI'+string(strmid(starids(i),3,6),format='(i6.6)')
;	'BSC': starids(i)='HR'+string(strmid(starids(i),3,4),format='(i4.4)')
;	'FKV': starids(i)='FK5'+string(strmid(starids(i),3,4),format='(i4.4)')
	'HDN': starids[i]='HD'+ID
	'HIP': starids[i]='HI'+ID
	'BSC': starids[i]='HR'+ID
	'FKV': starids[i]='FK5'+ID
	endcase
	endif
endfor
;
return,starids
;
end
