pro vlticonfig,uconf1,uconf2
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read *-model.dat files containing OPD models for VLTI and solve for
; a new vector of paths depending on telescope, delayline, and channel
; input indices. These input files can be found on wdline, /vltdata/pointing.
; A user specified configuration (e.g. 'UT113' for UT1, DL 1, IC 3)
; will be used to compute an improved estimate for OPL0.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
files=file_search(!oyster_dir+'vlti/opd/dl?UT???IP?-dl?UT???IP?_*-model.dat')
if strlen(files[0]) eq 0 then nf=0 else nf=n_elements(files)
if nf eq 0 then return
s=''
status=dc_read_free(!oyster_dir+'vlti/stations.config',s,x,y,z,d,/col,ignore=['!
stations=s
num_stations=n_elements(stations)
cterms=fltarr(num_stations)
; for i=0,num_stations-1 do cterms(i)=d(where(s eq stations(i)))
delaylines=lindgen(8)+1
inputchannels=lindgen(8)+1
num_delaylines=n_elements(delaylines)
num_inputchannels=n_elements(inputchannels)
maxrow=1000
m=fltarr(maxrow,num_stations+num_delaylines+num_inputchannels)
y=fltarr(maxrow)
n=0
for i=0,nf-1 do begin
	openr,unit,files[i],/get_lun
	l=''
	readf,unit,l
	readf,unit,l
	readf,unit,l
	free_lun,unit
	words=nameparse(l)
	y[n]=float(words[1])/1e6
	conf1=strmid(specname(files[i]),0,11)
	conf2=strmid(specname(files[i]),12,11)
;
	dl1=long(strmid(conf1,2,1))-1
	st1=long(strmid(conf1,5,1))-1
	ic1=long(strmid(conf1,10,1))-1
;
	dl2=long(strmid(conf2,2,1))-1
	st2=long(strmid(conf2,5,1))-1
	ic2=long(strmid(conf2,10,1))-1
;
	m[n,st1]=+1
	m[n,st2]=-1
;
	m[n,num_stations+dl1]=+1
	m[n,num_stations+dl2]=-1
;
	m[n,num_stations+num_delaylines+ic1]=+1
	m[n,num_stations+num_delaylines+ic2]=-1
;
	n=n+1
endfor
ct=total(abs(m),1)
nums=num_stations
numd=num_delaylines
numc=num_inputchannels
index_s=where(ct[0:nums-1] gt 0,num_stations)
index_d=where(ct[nums:nums+numd-1] gt 0,num_delaylines)
index_c=where(ct[nums+numd:nums+numd+numc-1] gt 0,num_inputchannels)
index=where(ct gt 0,num_columns)
m=m[*,index]
stations=stations[index_s]
cterms=cterms[index_s]
delaylines=delaylines[index_d]
inputchannels=inputchannels[index_c]
;
n_a_l=3
m=m[0:n-1+n_a_l,*]
y=y[0:n-1+n_a_l]
if n_a_l gt 0 then begin
	m[n+0,0]=1 & y[n+0]=cterms[0]
	m[n+1,num_stations]=1
	m[n+2,num_stations+num_delaylines]=1
endif
nrow=n
;
tm=transpose(m)
n=tm#m
r=tm#y
svdc,n,w,u,v
index=where(w/max(w) lt 1e-6,count) & if count gt 0 then w[index]=0
print,'Edited ',count,' zero eigenvalues.'
s=svsol(u,w,v,r)
for i=0,num_stations-1 do print,'Station ',stations[i],s[i]
for i=0,num_delaylines-1 do print,'Delayline ID',delaylines[i],s[num_stations+i]
for i=0,num_inputchannels-1 do print,'Input channel ID',inputchannels[i],s[num_s
print,'O-C [mu]=',(y-m[0:nrow-1,*]#s)*1e6
;
if n_elements(uconf1) ne 0 and n_elements(uconf2) ne 0 then begin
	v=intarr(num_stations+num_delaylines+num_inputchannels)
	st1=strmid(uconf1,0,3)
	dl1=long(strmid(uconf1,3,1)) & dl1=where(delaylines eq dl1)
	ic1=long(strmid(uconf1,4,1)) & ic1=where(inputchannels eq ic1)
	i=where(stations eq st1)
	v[i]=1
	v[num_stations+dl1]=1
	v[num_stations+num_delaylines+ic1]=1
	st2=strmid(uconf2,0,3)
	dl2=long(strmid(uconf2,3,1)) & dl2=where(delaylines eq dl2)
	ic2=long(strmid(uconf2,4,1)) & ic2=where(inputchannels eq ic2)
	i=where(stations eq st2)
	v[i]=-1
	v[num_stations+dl2]=-1
	v[num_stations+num_delaylines+ic2]=-1
	print,'A1L=',total(v*s)
endif
;
end
