function vmk_teff,teff_in
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute (V-K)=f(teff) from Mozurkewich et al. 2003. Only for T <= 15000 K
;
; Invert fit from Mozurkewich et al. 2003
vmk=findgen(9)-1
teff=teff_vmk(vmk)
r=poly_fit(teff,vmk,5)
; plot,teff,vmk,psym=1
; oplot,teff,poly(teff,r)
;
teff=teff_in
limit=10000.
index=where(teff ge limit,count)
; count=0 ; Do not limit at this time
if count gt 0 then begin
	print,'Warning(VMK_TEFF): results not reliable for T > 10000 K!'
	teff[index]=limit
endif
;
return,poly(teff,r)
;
end
