pro volvoxcorr,apply=apply,remove=remove,metro=metro
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For data loaded in AMOEBA, run through pivotcorr and whitecorr. It is
; important to run pivotcorr first since these corrections have to be applied
; to the white light data too. For removal, the order is not relevant.
;
; The apply and remove keywords are provided to force action. They are translate
; into level 2 "orders" which cause whitecorr and pivotcorr to remove the
; corrections stored in whitedelay and metrodelay, respectively, no matter what
; state the toggle switch is in. This is because the toggle mode doesn't work
; with multiple nights as stored by AMOEBA.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common LocalVolvoxCorr,sign
;
; This makes the procedure work like a toggle switch
if n_elements(sign) eq 0 then sign=1 else sign=-sign
;
; If remove=1 then force removal of correction
if n_elements(remove) eq 0 then remove=0 else remove=remove gt 0
if remove and sign gt 0 then begin
	sign=-sign
	return
endif
;
; If apply=1 force application of correction
if n_elements(apply) eq 0 then apply=0 else apply=apply gt 0
if apply and sign lt 0 then begin
	sign=-sign
	return
endif
;
; The default is to apply metrology corrections too
if n_elements(metro) eq 0 then metro=1 else metro=metro gt 0
;
case sign of
	+1:begin
	   apply=2
	   remove=0
	   end
	-1:begin
	   apply=0
	   remove=2
	   end
endcase
;
for i=0,n_elements(geninfo.date)-1 do begin
        if geoinfo[i].systemid eq 'NPOI' then begin
                loadnight,geninfo[i].date
		if metro then pivotcorr,apply=apply,remove=remove,compute=0
			      whitecorr,apply=apply,remove=remove
		storenight,11
        endif
endfor
;
end
