function wdmap,model,epoch,lamda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Setup a call to the Wilson-Devinney (1992) code to get a map. Model is the
; binary model. Epoch is JD-2440000 and lamda in [m].
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
wdparms=setwdparms(model,epoch,lamda,spotparms)
;
icc=0L
maxcc=1000
ccc=lonarr(maxcc)
xcc=dblarr(maxcc)
ycc=dblarr(maxcc)
fcc=dblarr(maxcc)
;
status=linknload(!external_lib,'wilson',wdparms,spotparms,icc,ccc,xcc,ycc,fcc)
i=where(finite(fcc) eq 0,count)
;
ccc=ccc[0:icc-1]
xcc=xcc[0:icc-1]
ycc=ycc[0:icc-1]
fcc=fcc[0:icc-1]
angle=(90-model.ascendingnode)/RAD
rxcc=(-ycc*sin(angle)+xcc*cos(angle))*model.semimajoraxis
rycc=(+xcc*sin(angle)+ycc*cos(angle))*model.semimajoraxis
map=alloc_map(icc,ccc,rxcc,rycc,fcc)
;
return,map
;
end
