function wdrav,model,epochs,lamda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Setup a call to the Wilson-Devinney (1992) code to get radial velocities.
; Model is the binary model. Epochs are JD-2440000 and lamda in [m].
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
wdparms=setwdparms(model,epochs[0],lamda,spotparms)
;
icc=0L
maxcc=1000
ccc=lonarr(maxcc)
xcc=dblarr(maxcc)
ycc=dblarr(maxcc)
fcc=dblarr(maxcc)
;
n_epochs=n_elements(epochs)
phas=fltarr(maxcc)
hkm1=fltarr(maxcc)
hkm2=fltarr(maxcc)
;
phas[0:n_epochs-1]=((epochs-model.epoch)/model.period) mod 1
phas=phas-0.255
;
status=linknload(!external_lib,'devinney',wdparms,spotparms, $
	icc,ccc,xcc,ycc,fcc, $
	n_epochs,phas,hkm1,hkm2)
;
return,[[hkm1],[hkm2]]
;
end
