function wdsid,ra,dec,id2=id2
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return positions in WDS ID long int format, i.e. +HHMMFDDMM,
; or -HHMMFDDMM, with the sign corresponding to the sign of the
; declination.
;
; If keyword id2 is set to WDS StarIds (e.g., 'WDS04220+1932'),
; process these as well (e.g., resulting in +042201932.
;
if keyword_set(id2) then begin
	wds=strmid(id2,8,1)+strmid(id2,3,5)+strmid(id2,9,4)
	return,wds
endif
;
n=n_elements(ra)
;
rah=fix(ra)
ram=(ra-rah)*60
raf=(ram-fix(ram))*10
decd=fix(dec)
decm=(abs(dec-decd))*60
decf=(decm-fix(decm))*10
index=where(decd lt 0,count)
wds=strarr(n)+'+' & if count gt 0 then wds[index]='-'
wds=wds+string(rah,format='(i2.2)') $
       +string(fix(ram),format='(i2.2)') $
       +string(fix(raf),format='(i1.1)') $
       +string(abs(decd),format='(i2.2)') $
       +string(fix(decm),format='(i2.2)')
;
return,long(wds)
;
end
