function wdspos,id0
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given a WDS ID format string, convert to RA and DEC. May contain the WDS
; catalog identifier.
;
id=id0
index=where(strpos(id,'WDS') ge 0,count)
if count gt 0 then id[index]=strmid(id[index],3,11)
;
rah=float(strmid(id,1,2))
ram=float(strmid(id,3,3))/10
decd=float(strmid(id,6,2))
decm=float(strmid(id,8,3))/10
sign=strmid(id,0,1)
f=fltarr(n_elements(id))+1
index=where(sign eq '-',count)
if count gt 0 then f[index]=-1
;
return,[[rah+ram/60],[f*(decd+decm/60)]]
;
end
