function whereequal,v1,v2_in,words=words
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return indices into v1 where v1(index) equals one of v2.
; If v2 is a single string and words not set, treat as vector of characters.
; If v2 is a single string and words is set, treat as vector of words.
;
if size(v2_in,/type) eq 7L and n_elements(v2_in) eq 1 $
	and not keyword_set(words) $
	then v2=nameparse(v2_in,'') else v2=v2_in
if n_elements(v2) eq 1 then v2=v2[0]
;
index=lonarr(n_elements(v1))-1
for i=0L,n_elements(v2)-1 do begin
	j=where(v1 eq v2[i],count)
	if count gt 0 then index[j]=j
endfor
;
j=where(index ge 0,count)
if count eq 0 then index=-1 else index=index[j]
;
return,index
;
end
