pro whitecorr,base_time,base_del,remove=remove,apply=apply,compute=compute
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Subtract constant term corrections from calibrated delay data, i.e.
; the Grp-, Dry-, and Wet-delays. The corrections are derived from the
; GRP white light position minus a linear fit through the differences
; between the GRP and DRY white light delays. Note that the FDL delays
; are not corrected.
;
; The optional parameters are the fitted constant term values for the
; epochs given in the first parameter.
; Optional parameters: base_time (NumTime) [s]
;		       base_del(NumSid, NumTime) [microns]
;
; Every second call to this procedure reverses the action of the previous call!
; The remove and apply keywords force action, level 1 checks the status of the
; toggle switch (sign), level 2 forces application or removal of whitedelay.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common LocalWhiteCorr,sign
;
if checkdata([8,9]) ne 0 then return
;
if n_params() eq 1 then begin
	print,'***Error(WHITECORR): must have both time and corrections!'
	return
endif
;
; If compute=0 then take correction from whitedelay variable
if n_elements(compute) eq 0 then compute=1 else compute=compute gt 0
if n_elements(remove) eq 0 then remove=0
;
; Should have white light data for all siderostats
if n_elements(base_del) eq 0 and compute then begin
	w_exist=intarr(GenConfig.NumSid)
	for i=0,GenConfig.NumSid-1 do begin
		index=where(scans.starid eq 'FKV0000' $
			and scans.fdlposerr[i] gt 0 $
			and scans.drydelayerr[i] gt 0,count)
		if count eq 0 then begin
	   	if remove eq 0 then $
		print,'Warning(WHITECORR): no white light data for beam',i+1,'!'
		endif else w_exist[i]=1
	endfor
	if total(w_exist) eq 0 then begin
		if remove eq 0 then print,'No white light corrections applied!'
		return
	endif
endif
;
; This makes the procedure work like a toggle switch
if n_elements(sign) eq 0 then sign=1 else sign=-sign
;
if remove eq 1 and sign gt 0 then begin
	sign=-sign
	return
endif else if remove eq 2 then sign=-1
;
if n_elements(apply) eq 0 then apply=0
if apply eq 1 and sign lt 0 then begin
	sign=-sign
	return
endif else if apply eq 2 then sign=1
;
if sign gt 0 and compute then begin
;
	for i=0,GenConfig.NumSid-1 do begin
	  if n_elements(base_del) eq 0 then begin
	  if w_exist[i] then begin
	    index=where(scans.starid eq 'FKV0000' $
	   	    and scans.fdlposerr[i] gt 0)
	    d_fdl=scans[index].fdlpos(i)*(i ne GenConfig.RefStation-1)
	    d_fdl=d_fdl-avg(d_fdl)
	    t_fdl=scans[index].time
	    index=where(scans.starid eq 'FKV0000' $
	    	    and scans.grpdelayerr[i] gt 0)
	    d_grp=scans[index].grpdelay(i) & d_grp=d_grp-avg(d_grp)
	    t_grp=scans[index].time
	    index=where(scans.starid eq 'FKV0000' $
	    	    and scans.drydelayerr[i] gt 0)
	    d_dry=scans[index].drydelay(i) & d_dry=d_dry-avg(d_dry)
	    t_dry=scans[index].time
;	    index=where(scans.starid eq 'FKV0000' $
;		    and scans.wetdelayerr(i) gt 0)
;	    d_wet=scans(index).wetdelay(i) & d_wet=d_wet-avg(d_wet)
;		t_wet=scans(index).time
	    index=where(scans.starid eq 'FKV0000' $
	    	and scans.grpdelayerr[i] gt 0 $
	    	and scans.drydelayerr[i] gt 0)
	    d_del=scans[index].grpdelay(i)-scans[index].drydelay(i)
	    d_del=d_del-avg(d_del)
	    t_del=scans[index].time
	    scans[*].whitedelay(i)=reform(spline(t_grp,d_grp, $
							abs(scans.time))) $
	    	      -poly(abs(scans.time),poly_fit(t_del,d_del,1))
	  endif
	  endif else begin
	  	d_fdl=reform(base_del[i,*])/1d6
	  	t_fdl=base_time
	  	scans[*].whitedelay(i)=reform(interpol(d_fdl,t_fdl, $
							abs(scans.time)))
	  endelse
	endfor
endif
;
scans.grpdelay=scans.grpdelay-scans.whitedelay*sign
scans.drydelay=scans.drydelay-scans.whitedelay*sign
;scans.wetdelay=scans.wetdelay-scans.whitedelay*sign
;
if sign gt 0 then print,'White light correction applied.' $
             else print,'White light correction removed.'
;
end
