function wilson,model
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Iteratively compute the orbital phase for the inferior conjunction of
; the secondary when it eclipses the primary. Primary eclipse is defined
; in lcmap to be at phase zero (modulo the phase correction parameter).
; By convention the primary eclipse is deeper than the secondary eclipse
; and star A is the star which is eclipsed during primary eclipse.
;
; The orbital phase for epoch JD is defined as (JD-EPOCH(PERIASTRON))/PERIOD
;
; The ascending node is read taken from the model, without verification.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
if n_elements(model) eq 0 then model=binary_model[0]
;
RAD=180/!pi
nsteps=45L
;
phases=findgen(nsteps)/nsteps
epochs=phases*model.period+model.epoch
radii=fltarr(nsteps)
angle=fltarr(nsteps)
;
o_parms=fltarr(8)
o_parms[0]=model[0].semimajoraxis
o_parms[1]=model[0].eccentricity
o_parms[2]=model[0].inclination/RAD
o_parms[3]=model[0].periastron/RAD
o_parms[4]=model[0].apsidalmotion/RAD
o_parms[5]=model[0].ascendingnode/RAD
o_parms[6]=model[0].period
o_parms[7]=model[0].epoch
;
for i=0L,nsteps-1 do begin
	xy=true2app(epochs[i],o_parms,rho,theta,gen_model.ra,gen_model.dec)
	radii[i]=rho
	angle[i]=theta*RAD
endfor
;
; Identify ascending node
if min(abs(angle-model[0].ascendingnode)) gt 5 then $
	print,'Warning: phase grid too coarse in function WILSON!'
index=where(abs((angle-model[0].ascendingnode)) eq $
	 min(abs(angle-model[0].ascendingnode)))
asc_phase=phases[index[0]]
if asc_phase lt 0 then asc_phase=asc_phase+1
;
; Look around orbit for smallest separation
i=where(radii eq min(radii)) & i=i[0]
p0=phases[0]
if i eq 0 	 then phases=(findgen(nsteps)-nsteps/2)/nsteps
if i eq nsteps-1 then phases=(findgen(nsteps)+nsteps/2)/nsteps
if phases[0] ne p0 then begin
	epochs=phases*model.period+model.epoch
	for i=0L,nsteps-1 do begin
	    xy=true2app(epochs[i],o_parms,rho,theta,gen_model.ra,gen_model.dec)
	    radii[i]=rho
	    angle[i]=theta
	endfor
endif
i=where(radii eq min(radii)) & i=i[0]
;
; Make sure it is the inferior conjunction
; Star A is, by definition, the one at superior conjunction near phase zero
con_phase=phases[i]
if con_phase gt asc_phase then radii[i]=max(radii)
;
; Iteratively home into closest approach of components
repeat begin
	i=where(radii eq min(radii)) & i=i[0]
	dphase=phases[i+1]-phases[i-1]
	phases=dphase*findgen(nsteps)/nsteps+phases[i-1]
	epochs=phases*model.period+model.epoch
	for i=0L,nsteps-1 do begin
	    xy=true2app(epochs[i],o_parms,rho,theta,gen_model.ra,gen_model.dec)
	    radii[i]=rho
	    angle[i]=theta
	endfor
endrep until dphase lt 0.0001
i=where(radii eq min(radii)) & i=i[0]
con_phase=phases[i]
;
return,con_phase
;
end
