function wilson_wd,model
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
;     In IMLC, phase = 0 when eclipse occurs and arg_periastron = 90.
;     Therefore, we borrowed the following code from MODLOG in FNL
;     to calculate phase of the periastron, which is our zero point.
;
;     Function returns orbital phases for periastron, sup., and inferior conj.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_elements(model) eq 0 then model=binary_model[0]
if n_elements(phzero) eq 0 then phzero=0
;
e=binary_model[0].eccentricity
p=((binary_model[0].periastron+180) mod 360)*!pi/180	; secondary periastron
;
perr=p
if e eq 0 then perr=!pi/2
;
trc=!pi/2-perr
while trc lt 0 do trc=trc+2*!pi
while trc ge 2*!pi do trc=trc-2*!pi
htrc=0.5*trc
if abs(!pi/2-htrc) ge 7.0e-6 and abs(4.712389-htrc) ge 7.0e-6 then $
	ecan=2.0*atan(sqrt((1.0-e)/(1.0+e))*tan(htrc)) else ecan=!pi
xmc=ecan-e*sin(ecan)
if xmc lt 0 then xmc=xmc+2*!pi
phper=1.0-xmc/(2*!pi)
; conjph15 subroutine
ecfac=sqrt((1.d0-e)/(1.d0+e))
trsc=!pi/2-p
tric=3.d0*!pi/2-p
econsc=2.d0*atan(ecfac*tan(trsc/2))
econic=2.d0*atan(ecfac*tan(tric/2))
xmsc=econsc-e*sin(econsc)
xmic=econic-e*sin(econic)
pconsc=(xmsc+p)/(2*!pi)-0.25+phzero
pconic=(xmic+p)/(2*!pi)-0.25+phzero
;
while pconsc ge 1.0 do pconsc=pconsc-1.0
while pconsc lt 0.0 do pconsc=pconsc+1.0
while pconic ge 1.0 do pconic=pconic-1.0
while pconic lt 0.0 do pconic=pconic+1.0
phperi=phper+pconsc	; phase of periastron
;
return,[phperi,pconsc,pconic]
;
; John Southword code (jktebop)
pi=pi_circle
ecc=e
argper=p/(180/pi_circle)
pih=pi/2
pi32=1.5*pi
twopi=2*pi
ecfac=sqrt((1.d0-ecc)/(1.d0+ecc))
;
trsc=pih-argper
tric=pi32-argper
econsc=2.d0*atan(ecfac*tan(.5d0*trsc))
econic=2.d0*atan(ecfac*tan(.5d0*tric))
xmsc=econsc-ecc*sin(econsc)
xmic=econic-ecc*sin(econic)
pconsc=(xmsc+argper)/twopi-.25d0+phzero
pconic=(xmic+argper)/twopi-.25d0+phzero
;
return,[pconsc,pconic]
;
end
