pro window_slide,xsize=xsize,ysize=ysize,xv=xv,yv=yv,index=index,wid=wid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Open a plot window with sliders.
;
if not keyword_set(xsize) then xsize=640*2
if not keyword_set(ysize) then ysize=512
;
if n_elements(yv) eq 0 then begin
	if ysize gt 512 then yv=512 else yv=ysize
endif
if n_elements(xv) eq 0 then begin
	if xsize gt 640 then xv=640 else xv=xsize
endif
;
slide_image,show_full=0,slide_window=index,xsize=xsize,ysize=ysize, $
	xvisible=xv,yvisible=yv,block=0,top_id=wid,/register
;
!x.ticks=min([xsize/500,50])
!y.ticks=0
!y.ticklen=10./xsize
!x.style=1
!y.style=1
!p.multi=0
!x.margin=[12,3]
;
wset,index
;
end
