function winkel,ra1,dec1,ra2,dec2,theta
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given two positions on the sky, return the angle between them in degrees.
; Input in hours and degrees, including fractions. Theta is the position angle.
;
; Michael Greaney, Chapter 25, Observing and Measuring Visual Double Stars
; (The Patrick Moore Practical Astronomy Series) 2nd Edition R. W. Argyle
; http://www.stargazing.net/david/doublestars/DoubleStarRhoTheta.html
;
rad=180/!pi
;
ra1rad=ra1*15/rad
ra2rad=ra2*15/rad
dec1rad=dec1/rad
dec2rad=dec2/rad
;
cos_rho=cos(dec1rad)*cos(dec2rad)*cos(ra1rad-ra2rad)+sin(dec1rad)*sin(dec2rad)
;
nominator=cos(dec1rad)*cos(dec2rad)*sin(ra2rad-ra1rad)
denominator=sin(dec2rad)-cos_rho*sin(dec1rad)
tan_theta=denominator*0
index=where(denominator ne 0,count)
tan_theta[index]=nominator[index]/denominator[index]
theta=atan(tan_theta)*rad
;
; It can happen that cos(rho) is infinitesimally larger then 1
index=where(cos_rho gt 1.,count)
if count gt 0 then cos_rho[index]=1
;
return,acos(cos_rho)*rad
;
end
