pro write_calvin
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Write startable to file conforming to CalVin data base format
;
common StarBase,StarTable,Notes
;
n=n_elements(startable)
;
names=strarr(n)
for i=0,n-1 do begin
	cat=strmid(startable[i].starid,0,3)
	if cat eq 'HDN' $
	or cat eq 'CAL' then starid='HD'+strmid(startable[i].starid,3,6) $
			else starid=startable[i].starid
	name='          '
	strput,name,starid
	names[i]=name
endfor
ra=hms(startable.ra,/aspro)
hhr=strmid(ra,0,2)
mmr=strmid(ra,3,2)
ssr=strmid(ra,6,5)
dec=dms(startable.dec,/aspro)
si=strmid(dec,0,1)+'1'
ddd=strmid(dec,1,2)
mmd=strmid(dec,4,2)
ssd=strmid(dec,7,4)
epoch='2000'
; V
mv=string(startable.mv,format='(f6.2)')
i=where(startable.mv eq 100,c)
if c gt 0 then mv[i]='-99e99'
; R
mr=strarr(n)+'-99e99'
; J
mj=string(startable.mj,format='(f6.2)')
i=where(startable.mj eq 100,c)
if c gt 0 then mj[i]='-99e99'
; H
mh=string(startable.mh,format='(f6.2)')
i=where(startable.mh eq 100,c)
if c gt 0 then mh[i]='-99e99'
; H
mk=string(startable.mk,format='(f6.2)')
i=where(startable.mk eq 100,c)
if c gt 0 then mk[i]='-99e99'
; L
ml=strarr(n)+'-99e99'
; M
mm=strarr(n)+'-99e99'
; N
mn=string(jy2n(startable.f12),format='(f6.2)')
i=where(startable.f12 eq 0,c)
if c gt 0 then mn[i]='-99e99'
; Q
mq=strarr(n)+'-99e99'
; Spectrum
spectra=strarr(n)
for i=0,n-1 do begin
	spectrum='          '
	strput,spectrum,startable[i].spectrum
	spectra[i]=spectrum
endfor
spec_parse,spectra,types,classes
lc=strarr(n)+'V     '
i=where(classes eq 1,c)
if c gt 0 then lc[i]='I     '
i=where(classes eq 1.25,c)
if c gt 0 then lc[i]='Iab   '
i=where(classes eq 1.5,c)
if c gt 0 then lc[i]='Ib    '
i=where(classes eq 1.75,c)
if c gt 0 then lc[i]='I/II  '
i=where(classes ge 2 and classes lt 3,c)
if c gt 0 then lc[i]='II    '
i=where(classes eq 2.5,c)
if c gt 0 then lc[i]='II/III'
i=where(classes ge 3 and classes lt 4,c)
if c gt 0 then lc[i]='III   '
i=where(classes eq 3.5,c)
if c gt 0 then lc[i]='III/IV'
i=where(classes ge 4 and classes lt 5,c)
if c gt 0 then lc[i]='IV    '
i=where(classes eq 4.5,c)
if c gt 0 then lc[i]='IV/V  '
i=where(classes ge 5,c)
if c gt 0 then lc[i]='V     '
; F (quality flag), use the status flag
f=startable.sflag
; Diameter
theta=string(startable.diameter,format='(f5.2)')
; etheta=string(startable.diametere,format='(f5.2)')
etheta=0	; Nov 3, 2015, diametere no longer in startable
; Model and instrument
model=strarr(n)+blanks(max(strlen(startable.model)))
instrument=strarr(n)
for i=0,n-1 do begin
	m=model[i]
	strput,m,startable[i].model
	model[i]=m
	case strtrim(model[i],2) of
	'UDN':instrument[i]='MIDI   '
	'LDN':instrument[i]='MIDI   '
	'UDK':instrument[i]='AMBER'
	'LDK':instrument[i]='AMBER'
	 'LD':instrument[i]='VLTI   '
	else: instrument[i]='VLTI   '
	endcase
endfor
; Teff
teff=string(fix(startable.teff),format='(i6.6)')
i=where(startable.teff eq 0,c)
if c gt 0 then teff[i]='-99e99'
; log(g)
logg=string(startable.logg,format='(f6.2)')
i=where(startable.logg eq 0,c)
if c gt 0 then logg[i]='-99e99'
; Mass
mass=string(startable.mass,format='(f6.2)')
i=where(startable.mass eq 0,c)
if c gt 0 then mass[i]='-99e99'
; V sin(i)
vsini=string(startable.vsini,format='(f6.2)')
i=where(startable.vsini eq 0,c)
if c gt 0 then vsini[i]='-99e99'
; Radial velocity
vrad=string(startable.rv,format='(f6.2)')
i=where(startable.rv eq 0,c)
if c gt 0 then vrad[i]='-99e99'
; Parallax
pi=string(startable.px*1000,format='(f7.2)')
i=where(startable.px eq 0,c)
if c gt 0 then pi[i]=' -99e99'
; Parallax error
epi=string(startable.pxe*1000,format='(f6.2)')
i=where(startable.pxe eq 0,c)
if c gt 0 then epi[i]='-99e99'
; Proper motion in RA
pmra=string(startable.pmra*150*cos(startable.dec/(180/!pi)),format='(f7.1)')
i=where(startable.pmra eq 0,c)
if c gt 0 then pmra[i]=' -99e99'
; Proper motion in Dec
pmdec=string(startable.pmdec*10,format='(f7.1)')
i=where(startable.pmdec eq 0,c)
if c gt 0 then pmdec[i]=' -99e99'
; Z
z=strarr(n)+'-99e99'
; Reference
ref=startable.reference
;
; Open file; extension indicates that it is CALVIN format
openw,unit,'list.calvin',/get_lun
s=' '
;
models=['UDJ','UDH','UDK']
instruments=['AMBER_J','AMBER_H','AMBER_K']
wavelengths=[1210.0,1650.0,2175.0]
x=alog10(wavelengths)
;
for i=0,n-1 do begin
;
for j=0,n_elements(wavelengths)-1 do begin
u=10^(startable[i].a0+startable[i].a1*x[j]+startable[i].a2*x[j]^2)
if total([startable[i].a0,startable[i].a1,startable[i].a2]) eq 0 then u=0.0
UD=startable[i].diameter/sqrt(((1-u/3)/(1-7*u/15)))
if strpos(instrument[i],'AMBER') ge 0 then begin
	model[i]=models[j]
	instrument[i]=instruments[j]
endif
theta[i]=string(UD,format='(f5.2)')
entry=names[i]+s $
	+hhr[i]+s+mmr[i]+s+ssr[i]+s+si[i]+s+ddd[i]+s+mmd[i]+s+ssd[i]+s+epoch+s $
	+mv[i]+s+mr[i]+s+mj[i]+s+mh[i]+s+mk[i]+s+ml[i]+s+mm[i]+s+mn[i]+s+mq[i]+s $
	+spectra[i]+s+lc[i]+s+f[i]+s+theta[i]+s+etheta[i]+s+model[i]+s $
	+teff[i]+s+logg[i]+s+mass[i]+s+vsini[i]+s+vrad[i]+s+pi[i]+s+epi[i]+s $
	+pmra[i]+s+pmdec[i]+s+z[i]+s+instrument[i]+s+ref[i]
if strpos(instrument[i],'AMBER') ge 0 or j eq 0 then printf,unit,entry
;
endfor
;
endfor
;
free_lun,unit
;
end
