pro write_iris
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Write star table to text file with info useful for IRIS observations.
;
common StarBase,StarTable,Notes
;
openw,unit,'stars_iris.txt',/get_lun
;
t=startable
;
printf,unit,'!  HIP  HR                RA (2000)        Dec (2000)           V
for i=0L,n_elements(t)-1L do begin
	printf,unit,t[i].hic,t[i].bsc,t[i].name,hms(t[i].ra),dms(t[i].dec), $
		t[i].spectrum,t[i].mv,t[i].mh,t[i].mk,t[i].a,t[i].dmv, $
		format='(i6,1x,i4,2x,a9,1x,a14,1x,a14,2x,a8,3(f4.1,1x),2(1x,f5.1))'
endfor
;
free_lun,unit
;
end
