pro write_latex
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Write file in LATEX format containing the star list.
;
common StarBase,StarTable,Notes
;
openw,unit,'stars.tex',/get_lun
;
header='  Star      Name       SB  BAT  FK5   '+ $
	'HR     HD   mV   mK (B-V)   D         Spectrum      '+ $
	'P [d]  ecc.  incl. a [mas] Flag'
;
printf,unit,'\documentstyle[11pt]{report}'
printf,unit,'\topmargin -3cm'
printf,unit,'\oddsidemargin -2cm'
printf,unit,'\textheight 26cm'
printf,unit,'\textwidth 21cm'
printf,unit,'\pagestyle{empty}'
printf,unit,'\begin{document}'
printf,unit,'{\tt\scriptsize\begin{verbatim}'
;
for i=0,n_elements(StarTable)-1 do begin
	if i mod 76 eq 0 then printf,unit,header
	if StarTable[i].mf ne 0 then sb=1 else sb=2
	printf,unit, $
	StarTable[i].starid,StarTable[i].name,sb, $
	StarTable[i].bat,StarTable[i].fkv, $
	StarTable[i].bsc,StarTable[i].hdn, $
	StarTable[i].mv,Startable[i].mk,StarTable[i].bv,StarTable[i].diameter, $
	strcompress(StarTable[i].spectrum,/remove_all), $
	StarTable[i].p,StarTable[i].e,StarTable[i].i,StarTable[i].a*1000., $
	StarTable[i].sflag, $
	format='(a9,1x,a12,1x,i1,2x,i4,1x,i4,1x,i4,1x,i6,1x,'+ $
		'f4.1,1x,f4.1,1x,f5.2,1x,f4.1,1x,a17,1x,f8.1,2x,f4.2,2x,f4.0,1x,f7.1,3x,a2)'
endfor
;
printf,unit,'\end{verbatim}}'
printf,unit,'\end{document}'
;
free_lun,unit
;
end
