pro write_rdb
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Write star table in rdb format for use in Apes.
;
common StarBase,StarTable,Notes
;
openw,unit,'stars.rdb',/get_lun
;
t=startable
n=n_elements(t)
;
stype=strarr(n) & stype[*]='T    '
star_id=strarr(n) & star_id[*]='HD '+string(t.hdn,format='(i6.6)')
alpha=hms(t.ra,/aspro)
delta=dms(t.dec,/aspro)
coord_syst=strarr(n) & coord_syst[*]='ICRS         '
epoch=strarr(n) & epoch[*]='J2000  '
equinox=strarr(n) & equinox[*]='2000.00'
mualpha=string(fix(((t.pmra)/15)*100/cos(t.dec*!pi/180)),format='(f7.1)')
mudelta=string(fix(t.pmdec*100),format='(f7.1)')
sp_type=strarr(n)
for i=0,n-1 do begin
sp_type_s=blanks(10)
strput,sp_type_s,t[i].spectrum
sp_type[i]=sp_type_s
endfor
magk=string(t.mk,format='(f6.1)')
magv=string(t.mv,format='(f6.1)')
magh=string(t.mh,format='(f6.1)')
;
stype_s=blanks(strlen(stype[0])) & strput,stype_s,'stype'
star_id_s=blanks(strlen(star_id[0])) & strput,star_id_s,'star_id'
alpha_s=blanks(strlen(alpha[0])) & strput,alpha_s,'alpha'
delta_s=blanks(strlen(delta[0])) & strput,delta_s,'delta'
coord_syst_s=blanks(strlen(coord_syst[0])) & strput,coord_syst_s,'coord_syst'
epoch_s=blanks(strlen(epoch[0])) & strput,epoch_s,'epoch'
equinox_s=blanks(strlen(equinox[0])) & strput,equinox_s,'equinox'
mualpha_s=blanks(strlen(mualpha[0])) & strput,mualpha_s,'mualpha'
mudelta_s=blanks(strlen(mudelta[0])) & strput,mudelta_s,'mudelta'
sp_type_s=blanks(strlen(sp_type[0])) & strput,sp_type_s,'SP_type'
magK_s=blanks(strlen(magK[0])) & strput,magK_s,'magK'
magV_s=blanks(strlen(magV[0])) & strput,magV_s,'magV'
magH_s=blanks(strlen(magH[0])) & strput,magH_s,'magH'
;
stype_d=dashes(strlen(stype[0]))
star_id_d=dashes(strlen(star_id[0]))
alpha_d=dashes(strlen(alpha[0]))
delta_d=dashes(strlen(delta[0]))
coord_syst_d=dashes(strlen(coord_syst[0]))
epoch_d=dashes(strlen(epoch[0]))
equinox_d=dashes(strlen(equinox[0]))
mualpha_d=dashes(strlen(mualpha[0]))
mudelta_d=dashes(strlen(mudelta[0]))
sp_type_d=dashes(strlen(sp_type[0]))
magK_d=dashes(strlen(magK[0]))
magV_d=dashes(strlen(magV[0]))
magH_d=dashes(strlen(magH[0]))
;
printf,unit,stype_s,star_id_s,alpha_s,delta_s,coord_syst_s,epoch_s,equinox_s, $
	mualpha_s,mudelta_s,sp_type_s,magk_s,magv_s,magh_s, $
	format='(12(a,%"\t"),a)'
printf,unit,stype_d,star_id_d,alpha_d,delta_d,coord_syst_d,epoch_d,equinox_d, $
	mualpha_d,mudelta_d,sp_type_d,magk_d,magv_d,magh_d, $
	format='(12(a,%"\t"),a)'
for i=0,n-1 do printf,unit,stype[i],star_id[i], $
	alpha[i],delta[i],coord_syst[i],epoch[i], $
	equinox[i],mualpha[i],mudelta[i], $
	sp_type[i],magk[i],magv[i],magh[i], $
	format='(12(a,%"\t"),a)'
;
free_lun,unit
;
end
