pro writeobslist,from_data,time=time
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Update rise and set times for stars listed in the startable, and
; write startable in obslist format. Time can be either GST or UTC.
;
common StarBase,startable,notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
num_stars=n_elements(startable)
if num_stars eq 0 then begin
	print,'***Error(WRITEOBSLIST): no stars defined!'
	return
endif
;
if n_elements(from_data) eq 0 then from_data=0
;
riseset,uptime
if n_elements(uptime) eq 0 then return
if from_data then roseset,uptime
;
read_notes
;
openw,unit,Date+'.obs',/get_lun
;
if n_elements(time) eq 0 then time='UTC'
;
printf,unit, $
'! Observing list for: ',Date
case strupcase(time) of
	'UTC': printf,unit, $
'! Star        Name  Type m_V   D  Int Sp. PI   RA (BG)  Dec   | Rise (UT) Set'
	'GST': printf,unit, $
'! Star        Name  Type m_I   D  Int Sp. PI   RA (BG)  Dec   | Rise (GST) Set'
endcase
;
for i=0,n_elements(startable)-1 do begin
	case time of
		'UTC':begin
		      vi=0.0
		      rise=uptime[0,i]/3600
		      if rise lt 0 then rise=rise+24
		      set= uptime[1,i]/3600
		      end
		'GST':begin
		      r=[2.01,0.82,2.53]
		      r=[1.87,0.89,1.28]
		      vi=2.5*alog10(poly(startable[i].bv,r)/1.87)
		      rise=ut12gst(uptime[0,i],uptime[0,i])
		      set= ut12gst(uptime[1,i],uptime[1,i])
		      end
	endcase
	it=90
	star='CCCNNNN  '
	strput,star,startable[i].starid
;
;	Locate suitable background field for this star
	radec=bglocation(startable[i].ra,startable[i].dec)
;
	printf,unit,star,strcompress(startable[i].name), $
		startable[i].bflag,startable[i].mv-vi,startable[i].diameter, $
		it,strcompress(startable[i].spectrum,/remove_all),'____ ', $
		radec[0],radec[1],' | ', $
		hms(rise),hms(set), $
	format='(a9,1x,a11,1x,a1,1x,f4.1,1x,f4.1,1x,i3,1x,a2,1x,a5,f7.4,1x,f7.3,a3,a7,2
endfor
printf,unit,'!------------------------------------------------------------------
for i=0,n_elements(startable)-1 do begin
	list_note,startable[i].starid,note
	if strlen(note[0]) ne 0 then begin
		for j=0,n_elements(note)-1 do $
			printf,unit,'! '+strmid(note[j],0,78)
		printf,unit,'!----------------------------------------------------------------
	endif
endfor
;
free_lun,unit
;
end
