pro ww_access,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Dispatch for ACCESS button.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,ScanTable,BGTable,StationTable
common Starbase,StarTable,Notes
;
widget_control,event.id,get_value=command
;
case command of
'Tree'     	:begin
	    	 list_tree
	    	 print,'Listing complete.'
	    	 end
'BROWSE'   	:ww_browse
'INTERFEROMETRY':begin
	    	 get_format,format
	    	 case format of
	    		'CONSTRICTOR':	begin
	    	 			get_sysconfig
	    	 			get_scantable
	    				get_bgdata
					fixearlydays
					get_startable
	    	 			get_constrictorlog
					get_observerlog
					ww_loadstar,event
					end
	    		'CHAMELEON':	begin
					get_scandata
					end
			else:		begin
					print,'***Error(WW_ACCESS): '+ $
						'wrong format!'
					return
					end
	    	 endcase
	    	 read_notes
	    	 end
'METROLOGY'     :begin
		 get_format,format
		 case format of
			'INCHWORM':	begin
					if n_elements(GenConfig) eq 0 then $
					get_genconfig
					if n_elements(GeoParms) eq 0 then $
					get_geoparms
					if n_elements(ScanTable) eq 0 then $
					get_scantable
					if n_elements(StarTable) eq 0 then $
					get_startable
		 			ww_loadmetrosel,event
					end
			else:		begin
					print,'***Error(WW_ACCESS): '+ $
						'wrong format!'
					return
					end
		 endcase
		 end
endcase
;
end
