pro ww_astromsolve
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Display a widget to compute single-night solutions for station coordinates
; and star positions.
;
common SetFitStarsInfo,sel_stars,stars_directive	; Local common block (2)
common SetStationsInfo,sel_stations,stations_directive	; Local common block (2)
common FitInfo,fit_stations,fit_stars,fit_data,fit_nights,fit_parms
common ChameleonWids,plot_wid,td_wid,cal_wid,astrom_wid,pivot_wid,triple_wid
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,ScanTable,BGTable,StationTable
;
; This is to tell the compiler that ww_astromfit is a function
forward_function ww_astromfit
;
; Remove existing widget
if n_elements(astrom_wid) eq 0 then astrom_wid=0L
if astrom_wid ne 0 then widget_control,astrom_wid,/destroy
;
astrom_wid=widget_base(title='AstrometrySolve',resource_name='oyster',/column, $
	kill_notify='ww_astromdestroyed',uvalue='Astrom', $
	xoffset=!dxsize-504,yoffset=!dysize-307)
;
; First two widget elements are in a row
row1_wid=widget_base(astrom_wid,/row)
;
; Station selection
station_dirs=['All','Sel']
stations_directive='All'
list_stations,fit_stations
index=where(total(scantable.station[0:GenConfig.NumSid-1,*],2) ne 0,count)
if count eq 0 then begin
	print,'***Error(WW_ASTROM): no data!'
	return
endif
fit_stations=fit_stations[index]
sel_stations=''
column1_wid=widget_base(row1_wid,/column)
opmenustn_wid=widget_droplist(column1_wid,title='Stns:', $
	value=station_dirs,uvalue=station_dirs, $
	event_pro='ww_setstations')
list1_wid=widget_list(column1_wid,value=fit_stations,uvalue=fit_stations,/multip
	event_pro='ww_setstations',xsize=3,ysize=3)
;
; Star selection
star_dirs=['All','Sel']
stars_directive='Sel'
fit_stars=''
sel_stars=''
column2_wid=widget_base(row1_wid,/column)
opmenustr_wid=widget_droplist(column2_wid,title='Stars:', $
	value=star_dirs,uvalue=star_dirs, $
	event_pro='ww_setfitstars')
widget_control,opmenustr_wid,set_droplist_select=1
list_stars,stars
list2_wid=widget_list(column2_wid,value=stars,uvalue=stars,/multiple, $
	event_pro='ww_setfitstars',ysize=3)
;
row2_wid=widget_base(astrom_wid,/row)
;
; Use uncorrected or corrected delays
data_dirs=['FDL','GRP','DRY','WET']
fit_data='FDL'
opmenuda_wid=widget_droplist(row2_wid,title='Data:', $
		value=data_dirs,uvalue=data_dirs, $
		event_pro='ww_setastrodata')
;
; Reference station
j=where(fit_stations eq GenConfig.StationId[GenConfig.RefStation-1])
stations=shift(fit_stations,-j[0])
ref_station=stations
opmenurs_wid=widget_droplist(row2_wid,title='Reference:', $
		value=ref_station,uvalue=ref_station, $
		event_pro='ww_setrefstation')
;
; Button box
button_wid=cw_bgroup(astrom_wid,/row,['Solve','Save','Load','HELP'], $
	event_funct='ww_astromfit',/return_name)
;
; Display widget
widget_control,astrom_wid,/realize
xmanager,'ww_astromsolve',astrom_wid,/no_block
;
end
