pro ww_browsefind,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Create list widget displaying the names of the components in an object
; selected from a list of objects (components) contained in an object.
; When necessary, annul active list widgets of higher order.
;
common Hds,path,hds_file_stub
common BrowseInfo,list_wids,item_wids,item_names,loc_id
;
; Return on second click of double-click
if event.clicks ne 1 then return
;
; Check if list widgets of higher order are active
i=0
while (item_wids[i] ne event.id) and (i le loc_id) do i=i+1
if i lt loc_id then begin
	widget_control,list_wids[i+1],/destroy
	l=loc_id
	for j=i+1,l do begin
		dat_annul
		loc_id=loc_id-1
	endfor
endif
;
; Get selected item name
widget_control,event.id,get_uvalue=names
name=names[event.index]
if strlen(name[0]) eq 0 then return
item_names[loc_id]=name
item_wids[loc_id]=event.id
;
dat_shape,ndim,dims
if ndim eq 0 then begin
	dat_find,name
	loc_id=loc_id+1
endif else if ndim eq 1 then begin
	cell=long(name)
	dat_cell,ndim,cell
	loc_id=loc_id+1
endif else begin
	cell=long(stringparse(name[0]))
	dat_cell,ndim,cell
	loc_id=loc_id+1
endelse
;
list_names,items
if n_elements(items) eq 0 then begin
	dat_annul
	loc_id=loc_id-1
	return
endif
;
window_wid=widget_base(event.top,title=name,group_leader=list_wids[loc_id-1])
list_wid=widget_list(window_wid,event_pro='ww_browsefind', $
	value=items,uvalue=items,ysize=6)
widget_control,window_wid,/realize
list_wids[loc_id]=window_wid
;
end
