pro ww_cal
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Display scan calibration selection widget.
;
common ChameleonWids,plot_wid,td_wid,cal_wid,astrom_wid,pivot_wid,triple_wid
common CalibrateWids,indicator_wids,list_wids,num_list
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common CalInfo,cal_entries
common SelCalStarsInfo,sel_stars,directive
;
; Remove cal and plot widgets if present
if n_elements(cal_wid) eq 0 then cal_wid=0L
if cal_wid ne 0 then widget_control,cal_wid,/destroy
;
; Initialize calibration control variables
initcal
num_indicators=n_elements(indicators)
indicator_wids=lonarr(num_indicators)
num_list=4 	; Number of function groups
list_wids=lonarr(num_indicators*num_list)
;
cal_wid=widget_base(/column,kill_notify='ww_caldestroyed', $
	resource_name='oyster', $
	xoffset=!dxsize-250,yoffset=!dysize-277,title='VisibilityCalibrate')
;
row1_wid=widget_base(cal_wid,/row)
;
list_indicators_wid=widget_list(row1_wid,value=indicators, $
	event_pro='ww_calindicator',/multiple,ysize=7)
;
column12_wid=widget_base(row1_wid,/column)
star_dirs=['All','Cal','Sel']
opmenu_wid=widget_droplist(column12_wid,title='Use:', $
	value=star_dirs,uvalue=star_dirs, $
	event_pro='ww_calstardir')
widget_control,opmenu_wid,set_droplist_select=2
directive='Sel'
;
list_stars,stars
list_stars_wid=widget_list(column12_wid,value=stars,uvalue=stars, $
	event_pro='ww_calstars',/multiple,ysize=4)
;
variables=[cal_options.n[0],cal_options.n[1],cal_options.n[2]]
opmenuvb_wid=widget_droplist(cal_wid,title='Variable:',value=variables, $
	event_pro='ww_setcalvar')
;
row2_wid=widget_base(cal_wid,/row)
;
button1_wid=cw_bgroup(row2_wid,['Calibrate','HELP'], $
		event_funct='ww_calok',/column,/return_name)
button2_wid=cw_bgroup(row2_wid,['Loop','Self'],/nonexclusive, $
		event_funct='ww_caloptions',/column)
;
column22_wid=widget_base(row2_wid,/column)
menu1=['1\Undo\ww_calutils', $
	'0\UNDO','0\Uncal','2\Reset']
menu2=['1\Entries\ww_calutils', $
	'0\Save','0\Load','0\Apply','0\Clear','0\List','6\EDIT']
menu1_wid=cw_pdmenu(column22_wid,menu1)
menu2_wid=cw_pdmenu(column22_wid,menu2)
;
widget_control,cal_wid,/realize
xmanager,'ww_cal',cal_wid,/no_block
;
end
