pro ww_calindicator,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Widget procedure to display and manage list widgets for the various
; indicators. The lists contain the base functions.
;
common ChameleonWids,plot_wid,td_wid,cal_wid,astrom_wid,pivot_wid,triple_wid
common CalibrateWids,indicator_wids,list_wids,num_list
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common CalInfo,cal_entries
common BaseFunctions,numlist,functions
;
forward_function ww_base
;
xpos=!dxsize-[1005,835,715,595,475,355,160]
ypos=!dysize-[447,447,447,447,447,447,447]
;
; Get names of indicators. These are in an array.
i=widget_info(event.id,/list_select)
if i[0] ge 0 then new_indicators=indicators[i] else new_indicators=''
if new_indicators[0] eq '' then num_indicators=0 else $
	num_indicators=n_elements(new_indicators)
;
; Find out which indicator has been added to the list
for i=0,num_indicators-1 do begin
	hit=0
;
;	These are the indicators already selected
	if (sel_indct[0] eq '') then num_sel=0 else $
		num_sel=n_elements(sel_indct)
	for j=0,num_sel-1 do $
		if new_indicators[i] eq sel_indct[j] then hit=1
;
;	If no match was found: a new indicator was selected
	index=where(strpos(sel_funcn[*,0],'S_') ge 0,do_smooth)
	if hit eq 0 then begin
;
;		Add new indicator to array through copying
		new_sel_indct=strarr(num_sel+1)
		if num_sel gt 0 then new_sel_indct[0:num_sel-1]=sel_indct
		new_sel_indct[num_sel]=new_indicators[i]
		sel_indct=new_sel_indct
;
;		Expand array sel_funcn to hold base functions for new indct.
		new_functions=strarr(num_sel+1,n_elements(sel_funcn[0,*]))
		if num_sel gt 0 then new_functions[0:num_sel-1,*]=sel_funcn
		sel_funcn=new_functions
;
;		Create new base function widget
		index=where(indicators eq new_indicators[i])
		list_index=[1,2]
		if new_indicators[i] eq 'Wavelength' then list_index=[1,2,3]
                if new_indicators[i] eq 'Time' $
                or new_indicators[i] eq 'HourAngle' then list_index=[1,2,4]
;
		indicator_wids[index[0]]=ww_base(new_indicators[i],list_index, $
			'ww_calfunction',listwids, $
			xpos[index[0]],ypos[index[0]],group_leader=cal_wid)
		widget_control,indicator_wids[index[0]], $
			set_uvalue=new_indicators[i]
;
;		Store the new list widget IDs
		list_wids[index[0]*num_list+0]=listwids[0]
		list_wids[index[0]*num_list+1]=listwids[1]
		if new_indicators[i] eq 'Wavelength' then $
		list_wids[index[0]*num_list+2]=listwids[2]
		if new_indicators[i] eq 'Time' $
		or new_indicators[i] eq 'HourAngle' then $
		list_wids[index[0]*num_list+3]=listwids[2]
;
;		Smoothing cannot be combined with any other function
		if do_smooth gt 0 then $
			widget_control,indicator_wids[index[0]],sensitive=0 $
		   else widget_control,indicator_wids[index[0]],sensitive=1
	endif
endfor
;
; Find out which indicator has been removed from the list
old_indicators=sel_indct
for i=0,n_elements(sel_indct)-1 do begin
	hit=0
	for j=0,num_indicators-1 do $
		if new_indicators[j] eq sel_indct[i] then hit=1
	if hit eq 0 then begin
;		sel_indct(i) was deselected and the funcn list has to be removed
;		Is this a list blocking others? If so, make others sensitive
		index=where(old_indicators eq sel_indct[i])
		blocking=strpos(sel_funcn[index,*],'S_') & blocking=blocking[0]
		if blocking ne -1 then begin
			for j=0,n_elements(indicators)-1 do begin
				if indicator_wids[j] ne 0 $
			       and indicators[j] ne sel_indct[i] then $
				widget_control,indicator_wids[j],sensitive=1
			endfor
		endif
		index=where(old_indicators ne sel_indct[i],count)
		if count gt 0 then begin
			old_indicators=old_indicators[index]
			sel_funcn=sel_funcn[index,*]
		endif else begin
			old_indicators=''
			sel_funcn=strarr(1,n_elements(functions))
		endelse
		index=where(indicators eq sel_indct[i])
		if indicator_wids[index[0]] ne 0 then $
			widget_control,indicator_wids[index[0]],/destroy
		indicator_wids[index[0]]=0
		list_wids[index[0]*num_list+0]=0
		list_wids[index[0]*num_list+1]=0
		list_wids[index[0]*num_list+2]=0
		list_wids[index[0]*num_list+3]=0
	endif
endfor
sel_indct=old_indicators
;
end
