function ww_calselok,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common FileSelInfo,file_dir,file_sel,sel_file,file_ext
common ModelFit,parameters,ds_options
;
case event.value of
'OK':	begin
	files=''
	case file_dir of
		'All'	:files=findfile('*.cal')
		'File'  :begin
			 if n_elements(sel_file) eq 0 then begin
			  	print,'***Error(WW_CALSELOK): file unspecified!'
			 return,-1
			 endif
			 result=findfile(sel_file,count=fcount)
			 if fcount eq 0 then begin
			  	print,'***Error(WW_CALSELOK): file not found!'
			  	return,-1
			 endif
			 if strpos(sel_file,'.cal') ne -1 then $
				files=sel_file else begin
			 status=dc_read_fixed(sel_file,files,resize=[1], $
			  	format='(a)',/col)
			 if status ne 0 then begin
				print,'***Error(WW_CALSELOK): error reading file!'
				return,-1
			 endif
			 endelse
			 end
		'List'  :if n_elements(file_sel) ne 0 then files=file_sel
	endcase
	if strlen(strcompress(files[0],/remove_all)) eq 0 then begin
		print,'***Error(WW_CALSELOK): no files specified!'
		return,-1
	endif
	mark32cha,files
     	end
'HELP':	begin
	print,'____________________________________________'
	print,'Select from files displayed in the list.    '
	print,'These should contain calibrated visibilities'
	print,'from MarkIII. The procedure will load the '
	print,'MarkIII data and store it into .cha files.'
	print,'Load options:                           '
	print,'All:  read all files listed.            '
	print,'File: read specified file for file list.'
	print,'List: read files selected in list.      '
	print,'__________________***_______________________'
	end
endcase
end
