pro ww_calutils,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common Hds,path,hds_file_stub
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common CalInfo,cal_entries
;
widget_control,event.id,get_value=command
case command of
	'UNDO' :ww_listcalreasons,'Undo'
	'Uncal':uncal
	'Reset':resetcal
;
	'Save' :begin
		save,filename=hds_file_stub+'.cal',cal_entries
		print,'Saved cal_entries.'
		end
	'Load' :begin
		if n_elements(hds_file_stub) eq 0 then return
		filename=hds_file_stub+'.cal'
		result=findfile(filename,count=fcount)
		if fcount ne 0 then restore,filename else begin
			print,'***Error(WW_OKCAL):',filename,' does not exist!'
			return
		endelse
		entries=cal_entries
		set_calentries,entries
		print,'Cal_entries loaded.'
		end
	'Apply':begin
		v=cal_options.v
		for i=0,2 do begin
			cal_options.v=i
			list_calreasons,reasons
			if reasons[0] ne '' then begin
				for j=0,n_elements(reasons)-1 do begin
					calibrate,reasons[j]
				endfor
			endif else begin
				print,'Warning(WW_CALOK): '+ $
				      'no entries for this variable: ',i,'!', $
				      format='(a,i1,a)'
			endelse
		endfor
		cal_options.v=v
		end
	'Clear':begin
		create_calentries
		print,'Cleared CalTable.'
		end
	'List' :list_calentries
	'EDIT' :ww_listcalreasons,'Edit'
endcase
;
end
