function ww_chamselok,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common FileSelInfo,files_sel,file_dir,filesel_file,filter
common ModelFit,parameters,ds_options
;
case event.value of
'OK':	begin
	files=''
	case file_dir of
		'All'	:files=findfile('*.cha')
		'File'  :begin
			 if n_elements(filesel_file) eq 0 then begin
			  	print,'***Error(WW_CHASELOK): file unspecified!'
			 return,-1
			 endif
			 result=findfile(filesel_file,count=fcount)
			 if fcount eq 0 then begin
			  	print,'***Error(WW_CHASELOK): file not found!'
			  	return,-1
			 endif
			 if strpos(filesel_file,'.cha') ne -1 then $
				files=filesel_file else begin
			 status=dc_read_fixed(filesel_file,files,resize=[1], $
			  	format='(a)',/col)
			 if status ne 0 then begin
				print,'***Error(WW_CHASELOK): error reading file!'
				return,-1
			 endif
			 endelse
			 end
		'List'  :if n_elements(files_sel) ne 0 then files=files_sel
	endcase
	if strlen(strcompress(files[0],/remove_all)) eq 0 then begin
		print,'***Error(WW_CHASELOK): no files specified!'
		return,-1
	endif
	cha2oifits,files
     	end
'HELP':	begin
	print,'____________________________________________'
	print,'Select from files displayed in the list.    '
	print,'These should contain calibrated visibilities'
	print,'from NPOI. The procedure will load the '
	print,'NPOI data and store it into .oifits files.'
	print,'Load options:                           '
	print,'All:  read all files listed.            '
	print,'File: read specified file for file list.'
	print,'List: read files selected in list.      '
	print,'__________________***_______________________'
	end
endcase
end
