function ww_chaselok,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Despite its name, this function also loads interferometry data in other
; format such as OIFITS, see load_interferometry.
;
common FileSelInfo,file_dir,file_sel,sel_file,file_ext
common ModelFit,parameters,ds_options
common ChameleonWids,plot_wid,td_wid,cal_wid,astrom_wid,pivot_wid,triple_wid
common WwDataSel,opmenul_wid,opmenuw_wid,opmenua_wid,opmenup_wid,opmenuf_wid
;
case event.value of
'OK':	begin
	if opmenua_wid eq 0 or opmenup_wid eq 0 then return,-1
	files=''
;	We should remove an old widget since it will be out of sync
	if n_elements(plot_wid) eq 0 then plot_wid=0L
	if plot_wid ne 0 then widget_control,plot_wid,/destroy
	case file_dir of
		'All'	:files=findfile(file_ext)
		'List'  :if n_elements(file_sel) ne 0 then files=file_sel
		'File'  :begin
			 if n_elements(sel_file) eq 0 then begin
			  	print,'***Error(WW_CHASELOK): file unspecified!'
			 	return,-1
			 endif
			 result=findfile(sel_file,count=fcount)
			 if fcount eq 0 then begin
			  	print,'***Error(WW_CHASELOK): file not found!'
			  	return,-1
			 endif
			 if strpos(sel_file,'.cha') ne -1 then $
				files=sel_file else begin
;			 Read file names from specified ("FileSpec") file
			 status=dc_read_fixed(sel_file,files,resize=[1], $
			  	format='(a)',/col)
			 if status ne 0 then begin
				print,'***Error(WW_CHASELOK): error reading file!'
				return,-1
			 endif
			 endelse
			 end
	endcase
	if strlen(strcompress(files[0],/remove_all)) eq 0 then begin
		print,'***Error(WW_CHASELOK): no files specified!'
		return,-1
	endif
;	IDL version 6.0.3 in a virtual machine can hang if widget is exposed
	if !version.release eq '6.0.3' then iconify_oyster
	load_interferometry,files
	if !version.release eq '6.0.3' then iconify_oyster,0
	if strlen(files[0]) eq 0 then return,0
;	Display plot widget
	ww_plot
;	Update the menu options in the DataInterferometry GUI
	types=['Vsqr','TAmp','Both','None']
	sds=3
	if ds_options.v2 then sds=0
	if ds_options.ta then sds=1
	if ds_options.v2 and ds_options.ta then sds=2
	widget_control,opmenua_wid,set_droplist_select=sds
	types=['VPhs','TPhs','Both','None']
	sds=3
	if ds_options.vp then sds=0
	if ds_options.tp then sds=1
	if ds_options.vp and ds_options.tp then sds=2
	widget_control,opmenup_wid,set_droplist_select=sds
;	widget_control,opmenuw_wid,set_droplist_select=1
	print,'Interferometric data type selection updated.'
     	end
'HELP':	begin
	print,'_____________________________________________'
	print,'Select from files displayed in the list.'
	print,'Files should contain calibrated visibilities.'
	print,'Load options:                           '
	print,'All:  read all files listed.            '
	print,'File: read specified file for file list.'
	print,'List: read files selected in list.      '
	print,'the specified file for a list of files.'
	print,'___________________***_______________________'
	end
endcase
;
end
