pro ww_datasel,datatype
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Displays GUI to select data files of a given type, e.g. CHA, VEL, PSN, MAG.
; The DataInterferometry widget allows to read CHA or FITS files.
;
common ModelFit,parameters,ds_options
common AmoebaWids,data_wid,mfit_wid,ifit_wid,afit_wid,control_wid
common FileSelInfo,file_dir,file_sel,sel_file,file_ext
common WwDataSel,opmenul_wid,opmenuw_wid,opmenua_wid,opmenup_wid,opmenuf_wid
;
; opmenu: 'l'=load, 'w'=weight', 'a'=amp, 'p'=phase, 'f'=flux
; file_dir: 'All' (in the curr. dir.), 'List' (sel. in GUI), or from 'File'
; file_sel: the data files selected with the GUI
; sel_file: the file with the list of files
; file_ext: extension of files to be listed
;
if n_elements(data_wid) eq 0 then data_wid=0L
if data_wid ne 0 then widget_control,data_wid,/destroy
opmenua_wid=0
opmenup_wid=0
;
case datatype of
	'cha':	begin
		datatitle='DataInterferometry'
		callback='ww_chaselok'
		buttons=['OK','HELP']
		d=1
		weight=ds_options.i
		end
	'psn':	begin
		datatitle='DataAstrometry'
		callback='ww_psnselok'
		buttons=['OK','HELP']
		d=2
		weight=ds_options.a
		end
	'vel':	begin
		datatitle='DataSpectroscopy'
		callback='ww_velselok'
		buttons=['OK','HELP']
		d=3
		weight=ds_options.s
		end
	'mag':	begin
		datatitle='DataPhotometry'
		callback='ww_magselok'
		buttons=['OK','HELP']
		d=4
		weight=ds_options.p
		end
endcase
data_wid=widget_base(kill_notify='ww_dataseldestroyed', $
		xoffset=568,yoffset=0, $
		title=datatitle,/column,resource_name='oyster')
row_wid=widget_base(data_wid,/row)
;
file_ext='*.'+datatype
if datatype eq 'cha' then file_ext=file_ext+' *.*fits'
files=findfile(file_ext)
if strlen(files[0]) eq 0 then begin
	print,'Warning(WW_DATASEL): no files found!'
	file_dir='File'
	current=3
endif else begin
	column1_wid=widget_base(row_wid,/column)
	label_wid=widget_label(column1_wid,value='Filter:')
	text_wid=widget_text(column1_wid,event_pro='ww_setfilter', $
		/editable,xsize=14,value=file_ext)
	list_files_wid=widget_list(column1_wid,value=files,uvalue=files, $
		event_pro='ww_setfiles',/multiple,ysize=8)
	widget_control,text_wid,set_uvalue=list_files_wid
	file_dir='All'
	current=1
endelse
;
column2_wid=widget_base(row_wid,/column)
file_dirs=['All','List','File']
opmenul_wid=widget_droplist(column2_wid,title='Load: ', $
	event_pro='ww_setfiledir',value=file_dirs,uvalue=file_dirs)
widget_control,opmenul_wid,set_droplist_select=current-1
file_sel=''
;
label_wid=widget_label(column2_wid,value='FileSpec:')
text_wid=widget_text(column2_wid,event_pro='ww_setfileselfile', $
	/editable,xsize=14)
;
if datatype eq 'cha' or datatype eq 'psn' $
or datatype eq 'vel' or datatype eq 'mag' then begin
	weights=['10','1','0.1','0']
	opmenuw_wid=widget_droplist(column2_wid,title='Weight:', $
		event_pro='ww_datweight',value=weights,uvalue={d:d,w:weights})
	widget_control,opmenuw_wid, $
		set_droplist_select=where(float(weights)-weight eq 0)
endif
;
; Additional options for some data types
if datatype eq 'cha' then begin
	types=['Vsqr','TAmp','Both','None']
	opmenua_wid=widget_droplist(column2_wid,title='Amp:  ', $
		event_pro='ww_dattype',value=types,uvalue='AMP '+types)
	sds=3
	if ds_options.v2 then sds=0
	if ds_options.ta then sds=1
	if ds_options.v2 and ds_options.ta then sds=2
	widget_control,opmenua_wid,set_droplist_select=sds
;
	types=['VPhs','TPhs','Both','None']
	opmenup_wid=widget_droplist(column2_wid,title='Phase:', $
		event_pro='ww_dattype',value=types,uvalue='PHS '+types)
	sds=3
	if ds_options.vp then sds=0
	if ds_options.tp then sds=1
	if ds_options.vp and ds_options.tp then sds=2
	widget_control,opmenup_wid,set_droplist_select=sds
;
	types=['Flux','None']
	opmenuf_wid=widget_droplist(column2_wid,title='Flux:', $
		event_pro='ww_dattype',value=types,uvalue='FLX '+types)
	sds=1
	if ds_options.fl then sds=0
	widget_control,opmenuf_wid,set_droplist_select=sds
endif
;
if datatype eq 'psn' then begin
	types=['Ell','Cir','Uni']
	opmenut_wid=widget_droplist(column2_wid,title='Type:  ', $
		event_pro='ww_psntype',value=types,uvalue=types)
	widget_control,opmenut_wid,set_droplist_select=0
endif
;
if datatype eq 'mag' then begin
	types=['Phot','Model']
	opmenut_wid=widget_droplist(column2_wid,title='Type:  ', $
		event_pro='ww_magtype',value=types,uvalue=types)
endif
;
button_wid=cw_bgroup(data_wid,buttons, $
		event_funct=callback,/row,/return_name)
;
widget_control,data_wid,/realize
xmanager,'ww_datasel',data_wid,/no_block
;
end
