pro ww_fitastrometry
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Fits (rho,theta) positions derived from interferometric or speckle data.
;
common AmoebaWids,data_wid,modelfit_wid,ifit_wid,afit_wid,control_wid
common FitAstrometry,ellipse_options,orbit_options,e_parms,o_parms
;
; Return if widget is already displayed
if n_elements(afit_wid) eq 0 then afit_wid=0
if afit_wid ne 0 then return
;
; Initialize options
if init_fitastrometry() ne 0 then return
;
; Check if model is loaded
list_poscomps,components
if components[0] eq '' then return
;
; Create the widget
afit_wid=widget_base(/column,kill_notify='ww_fitastrometrydestroyed', $
	resource_name='oyster', $
	title='FitAstrometry',xoffset=!dxsize-500,yoffset=300)
;
; Component selection
opmenu_wid=widget_droplist(afit_wid,title='Component: ', $
	event_pro='ww_fitastrometrycomp',value=components,uvalue=components)
orbit_options.component=components[0]
ellipse_options.component=components[0]
;
row_wid=widget_base(afit_wid,/row)
;
; Ellipse menu
column1_wid=widget_base(row_wid,/column)
button_wid=widget_button(column1_wid,value='Ellipse', $
	event_pro='ww_fitellipse')
option=['All', $
	'Center', $
	'Major axis', $
	'Minor axis', $
	'Position angle']
option_wid=cw_bgroup(column1_wid,option,/nonexclusive, $
	event_funct='ww_ellipsefitoptions')
;
; Orbit menu
column2_wid=widget_base(row_wid,/column)
button_wid=widget_button(column2_wid,value='Orbit', $
	event_pro='ww_fitorbit')
option=['All', $
	'Semimajoraxis', $
	'Eccentricity', $
	'Inclination', $
	'Periastron', $
	'Ascendingnode', $
	'Period', $
	'Epoch']
option_wid=cw_bgroup(column2_wid,option,/nonexclusive, $
	event_funct='ww_orbitfitoptions')
;
button_wid=cw_bgroup(afit_wid,['Get orbit','Set model','Help'], $
	event_funct='ww_fitastrometryutil',/row,/return_name)
;
; Display widget
widget_control,afit_wid,/realize
xmanager,'ww_astrometry',afit_wid,/no_block
;
end
