pro ww_fitinterferometry
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; GUI for fits of binary positions to visibility data.
;
common AmoebaWids,data_wid,modelfit_wid,ifit_wid,afit_wid,control_wid
common WwFitWids,list1_wids,list2_wids
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common LocalFitNights,cbcf
;
; Return if widget is already displayed
if n_elements(ifit_wid) eq 0 then ifit_wid=0
if ifit_wid ne 0 then return
;
; Create array to hold widget IDs of parameter lists
if num_binary() eq 0 then begin
	print,'***Error(WW_FITINTERFEROMETRY): no model!'
	return
endif
;
; No longer needed?
if 0 then begin
num_bin_comps=0
for i=0,num_binary()-1 do $
	if binary_model[i].method eq 2 then num_bin_comps=num_bin_comps+1
if num_bin_comps eq 0 then begin
	print,'***Error: no binary component defined by method 2 (rho,theta)!'
	return
endif
if num_bin_comps lt num_binary() then begin
	print,'Warning: not all binary components defined by method 2!'
endif
;
; Check data
if n_elements(geoinfo) eq 0 then begin
	print,'***Error(WW_FITINTERFEROMETRY): no data!'
	return
endif
endif
if n_elements(list1_wids) eq 0 then list1_wids=lonarr(num_binary())
if n_elements(list2_wids) eq 0 then list2_wids=lonarr(num_binary())
;
; Initialize options
if init_fitinterferometry() ne 0 then return
;
; Check cbcf (CLEAN beam conversion factor)
if n_elements(cbcf) eq 0 then cbcf=7.0
;
; Create the widget
ifit_wid=widget_base(kill_notify='ww_fitinterferometrydestroyed', $
	resource_name='oyster', $
	/row,title='FitInterferometry',xoffset=!dxsize-500,yoffset=300)
column1_wid=widget_base(ifit_wid,/column)
;
for i=0,num_binary()-1 do begin
	component=binary_model[i].component
	bin_wid=widget_base(column1_wid,/column)
;	label_wid=widget_label(bin_wid,value=component)
	button_wid=widget_button(bin_wid,value=component,uvalue=2, $
		event_func='ww_modellist')
	list_wid=widget_list(bin_wid, $
		value=posparms(),uvalue={c:component,p:posparms()}, $
		event_pro='ww_modelfitparameters',/multiple, $
		ysize=n_elements(posparms()))
;		if binary_model(i).method ne 2 then $
;			widget_control,list_wid,sensitive=0
	list2_wids[i]=list_wid
endfor
;
column2_wid=widget_base(ifit_wid,/column)
;
text_wid=widget_text(column2_wid,value='CLEAN beam CF',xsize=14)
text_wid=widget_text(column2_wid,value=string(cbcf,format='(f4.1)'),/editable, $
	event_pro='ww_fitinterferometrycbcf',xsize=14)
;
column3_wid=widget_base(ifit_wid,/column)
;
button_wid=cw_bgroup(column3_wid,['Fit','Help'],/return_name, $
	event_funct='ww_fitinterferometryok',/column)
;
; Display widget
widget_control,ifit_wid,/realize
xmanager,'ww_fitinterferometry',ifit_wid,/no_block
;
end
