pro ww_fitplotdata,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Fits selected functions to data in FitPlotData and plots the residuals.
;
common PlotUtilWids,base_wid,list_wids
common BaseFunctions,numlist,functions
common PlotDataInfo,plotscans,plotdata_x,plotdata_y,plotdata_y_bck
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common FitPlotData,x_mid,x_scl,s
;
; If error bars requested, use dot as plot symbol
if ps_options.e then psym=3 else psym=abs(!p.psym)
if ps_options.l then psym=-psym
;
; Get the selected base functions
i=where(list_wids eq event.id) & i=i[0]
sel_ids=widget_info(event.id,/list_select)
if min(sel_ids) ge 0 then list_functions=functions[i*5+sel_ids] $
		     else list_functions=''
num_functions=n_elements(list_functions)
;
; If all deselected, plot original data
if list_functions[0] eq '' then begin
	plotscans.y=plotdata_y_bck
	index=where(plotscans.xe gt 0 and plotscans.ye gt 0,count)
	if count gt 0 then begin
	plot,plotscans.x[index],plotscans.y[index],psym=psym, $
		xtype=!x.type,ytype=!y.type
	if ps_options.e then $
	oploterr,plotscans.x[index],plotscans.y[index],plotscans.ye[index],3
	endif
	return
endif
;
; Clear selection of all lists other then the one from which selected
index=where(list_wids eq event.id)
case index[0] of
	0:begin
	  widget_control,list_wids[1],set_value=functions[5:9]
	  widget_control,list_wids[2],set_value=functions[10:14]
	  widget_control,list_wids[3],set_value=functions[15:19]
	  end
	1:begin
	  widget_control,list_wids[0],set_value=functions[0:4]
	  widget_control,list_wids[2],set_value=functions[10:14]
	  widget_control,list_wids[3],set_value=functions[15:19]
	  end
	2:begin
	  widget_control,list_wids[0],set_value=functions[0:4]
	  widget_control,list_wids[1],set_value=functions[5:9]
	  widget_control,list_wids[3],set_value=functions[15:19]
	  end
	3:begin
	  widget_control,list_wids[0],set_value=functions[0:4]
	  widget_control,list_wids[1],set_value=functions[5:9]
	  widget_control,list_wids[2],set_value=functions[10:14]
	  end
endcase
;
; Set data
if not ps_options.r and total(abs(!x.range)+abs(!y.range)) ne 0 then begin
	xmin=!x.range[0]
	xmax=!x.range[1]
	ymin=!y.range[0]
	ymax=!y.range[1]
	if total(abs(!x.range)) eq 0 then begin
		xmin=min(plotdata_x)
		xmax=max(plotdata_x)
	endif
	if total(abs(!y.range)) eq 0 then begin
		ymin=min(plotdata_y_bck)
		ymax=max(plotdata_y_bck)
	endif
	index=where((plotdata_x ge xmin) and $
		    (plotdata_x le xmax) and $
		    (plotdata_y_bck ge ymin) and $
		    (plotdata_y_bck le ymax))
endif else index=indgen(n_elements(plotscans.x))
if index[0] eq -1 then begin
	print,'Warning(WW_FITPLOTDATA): no data in range!'
	index=indgen(n_elements(plotscans.x))
endif
x=plotscans.x[index]
y=plotdata_y_bck[index]
xe=plotscans.xe[index]
ye=plotscans.ye[index]
;
; Edit the data
index=where(xe gt 0 and ye gt 0,num_scans)
if num_scans eq 0 then begin
	print,'Warning(WW_FITPLOTDATA): no valid data!'
	return
endif
x=x[index] & y=y[index] & y_error=ye[index]
;
; Special logarithmic case
if !x.type eq 1 then x=alog10(x)
if !y.type eq 1 then begin
		     y_error=y_error/y
		     y=alog10(y)
endif
;
; Optional shifting and scaling for numerical stability
x_mid=(min(x)+max(x))/2 ; With scaling, fit coeffs are changed
x_scl=2/(max(x)-min(x))
;x_mid=0
;x_scl=1
;
; Weighted fit?
if ps_options.e then do_e=1 else do_e=0
;
; Note that wt is NOT 1/error^2 because of the following normalization!
if do_e then wt=1/y_error else wt=dblarr(num_scans)+1
;
if strpos(list_functions[0],'S_') ge 0 then begin
;	Smoothing
	smooth_time=float(strmid(list_functions[0],2,2))/60
	y_fit=y
	for i=0,num_scans-1 do begin
		twt=exp(-((x[i]-x)/smooth_time)^2)*wt
		y_fit[i]=total(y*twt)/total(twt)
	endfor
	y_res=y-y_fit
	if do_e then print,'Chi^2 = ',total((y_res/y_error)^2) $
		/(num_scans-(max(x)-min(x))/smooth_time)
endif else begin
; 	Analytical solution
	m=dblarr(num_scans,num_functions,/nozero)
	for i=0,num_functions-1 do $
		m[*,i]=evalfunction(list_functions[i],x,x_mid,x_scl)*wt
	y=y*wt
	tm=transpose(m)
	n=tm#m
	r=tm#y
	if num_functions gt 1 then begin
		svd,n,w
;		Full SVD call is: svd,n,w,u,v. v(*,i) is eigenvector to w_i
		if max(w)/min(w) gt 1e12 then begin
			print,'***Error(WW_FITPLOTDATA): equations ill-defined!'
			return
		endif
		s=invert(n)#r
	endif else s=1/n*r
	for i=0,num_functions-1 do $
		m[*,i]=evalfunction(list_functions[i],x,x_mid,x_scl)
	y=y/wt
	y_fit=m#s
	y_res=y-y_fit
;	if n_elements(unique(y_fit)) eq 1 then print,'Mean = ',y_fit(0)
	if do_e then print,'Chi^2 = ',total((y_res/y_error)^2) $
		/(num_scans-num_functions)
endelse
;
; Special logarithmic case
if !x.type eq 1 then x=10^x
if !y.type eq 1 then begin
		     y=10^y
		     y_error=y_error*y
		     y_res=10^y_res
endif
;
; Plot the residuals
plot,x,y_res,title='Residuals from fit', $
	yrange=[0,0],xmargin=[14,3],psym=psym,xtype=!x.type,ytype=!y.type
print,'RMS =',stddev(y_res)
if strpos(list_functions[0],'S_') lt 0 then print,'Coeffs =',s
if ps_options.e then oploterr,x,y_res,y_error,3
;
; Update plotdata
if strpos(list_functions[0],'S_') ge 0 then begin
	plotscans.y=plotdata_y_bck-spline(x,y_res,plotscans.x-x_mid)
endif else begin
	m=dblarr(n_elements(plotscans.y),num_functions,/nozero)
	for i=0,num_functions-1 do $
		m[*,i]=evalfunction(list_functions[i],plotscans.x,x_mid,x_scl)
	plotscans.y=plotdata_y_bck-m#s
endelse
;
end
