pro ww_indexob,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common SelDirs,nt_dir,nt_sel,st_dir,st_sel,x_dir,y_dir,z_dir,x_sel,y_sel,z_sel
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
widget_control,event.id,get_uvalue=stream
case stream of
	'x':i=ds_x.ob
	'y':i=ds_y.ob
	'z':i=ds_z.ob
endcase
print,genconfig.baselineid[0:genconfig.numbaseline[i]-1,i]
;
; With CalibrateSystem GUI, display selected fit results
if strpos(type,'APDFlux') ge 0 then begin
	print,'genconfig.apdflux for this output beam:'
	print,genconfig.apdflux[*,*,i]
endif
if strpos(type,'V2Bias') ge 0 then begin
	configs=strarr(n_elements(scanconfig(/starlist)))
	stars=configs
	for j=0,n_elements(scanconfig(/starlist))-1 do begin
        	words=nameparse(genconfig.config[j])
        	configs[j]=words[0]
		stars[j]=words[1]
	endfor
	index=where(configs eq y_dir.pt,count)
	if count gt 0 then begin
	print,'Non-zero values of genconfig.v2bias for this output beam:'
	for j=0,count-1 do begin
		values=transpose(genconfig.v2bias[*,*,*,i,index[j]])
		if total(abs(values)) gt 0 then begin
		print,stars[index[j]]+' ('+configs[index[j]]+')'
		print,values
		endif
	endfor
	endif
endif
if strpos(type,'TrackOffset') ge 0 then begin
	print,'genconfig.offsetcal for this output beam:'
	for bl=0,genconfig.numbaseline[i]-1 do begin
		print,genconfig.baselineid[bl,i]
		for j=0,genconfig.numspecchan[i]-1 do $
			print,genconfig.offsetcal[*,bl,j,i]
	endfor
endif
;
end
