pro ww_indexsel,event,stream
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Displays widget for the selection of data.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SelDirs,nt_dir,nt_sel,st_dir,st_sel,x_dir,y_dir,z_dir,x_sel,y_sel,z_sel
common DataSelWids,x_wid,x_shown,y_wid,y_shown,z_wid,z_shown
common IndexSelDropWids,dropch_wid,dropbl_wid,droptr_wid,droppt_wid
common IndexSelTextWids,textch_wid,textbl_wid,textpt_wid
common LocalWwSetDir,ch_dirs,bl_dirs,pt_dirs
common LocalWwIndexselRefresh,offsety,offseti,offsetd
;
title='IndexSelection, '+stream
;
; Create the widget
if n_elements(class) eq 0 then begin
	print,'***Error(WW_DATASEL): no class specified!'
	return
endif
;
offsety=20
datasel_wid=widget_base(group_leader=event.top,/floating, $
			resource_name='oyster', $
			kill_notify='ww_indexseldestroyed', $
			xoffset=380,yoffset=offsety, $
			title=title,/column,uvalue=stream,/kbrd_focus_events)
case stream of
	'x':x_wid=datasel_wid
	'y':y_wid=datasel_wid
	'z':z_wid=datasel_wid
endcase
;
; Input beam selection
classes=['point','delay','scan','astrom','amoeba','metro','seeing','phot','volvo
if long(where(classes eq class),0) ne -1 and GenConfig.NumSid gt 0 then begin
 inbeams=string(indgen(max(GenInfo.NumSid))+1)
 row_wid=widget_base(datasel_wid,/row)
 ib_wid=widget_button(row_wid,value='InputBeam: ',event_pro='ww_indexib', $
	uvalue=stream)
 opmenuib_wid=widget_droplist(row_wid,title='', $
	event_pro='ww_setinbeam',value=inbeams,uvalue=stream)
endif
;
; Output beam selection
classes=['point','delay','bg','scan','uv','ncal','amoeba','seeing']
if long(where(classes eq class),0) ne -1 and GenConfig.NumOutBeam gt 0 then begi
 outbeams=string(indgen(max(GenInfo.NumOutBeam))+1)
 row_wid=widget_base(datasel_wid,/row)
 ob_wid=widget_button(row_wid,value='OutputBeam:',event_pro='ww_indexob', $
	uvalue=stream)
 opmenuob_wid=widget_droplist(row_wid,title='', $
	event_pro='ww_setoutbeam',value=outbeams,uvalue=stream)
endif
;
; Triple selection
classes=['point','scan','amoeba','ncal']
if long(where(classes eq class),0) ne -1 $
and max(GenInfo.NumTriple) gt 0 then begin
 triples=string(indgen(max(GenInfo.NumTriple))+1)
 count=0
 if class ne 'amoeba' then $
 index=where(total(scantable.station,fix(size(scantable.station),0)) eq 0,count)
 if count gt 0 then begin
  for i=0,genconfig.numtriple-1 do begin
   for j=0,count-1 do begin
    if strpos(strjoin(genconfig.baselineid[genconfig.triplebase[*,i], $
					   genconfig.triplebeam[*,i]],' '), $
	      genconfig.stationid[index[j]]) ge 0 then triples[i]=''
   endfor
  endfor
  index=where(strlen(triples) gt 0,count)
  if count gt 0 then triples=triples[index]
 endif
 if total(strlen(triples)) ne 0 then begin
 row_wid=widget_base(datasel_wid,/row)
 tr_wid=widget_button(row_wid,value='Triple:    ',event_pro='ww_indextr', $
	uvalue=stream)
 opmenutr_wid=widget_droplist(row_wid,title='', $
	event_pro='ww_settriple',value=triples,uvalue=stream+triples)
 case stream of
	'x':ds_x.tr=triples[0]-1
	'y':ds_y.tr=triples[0]-1
	'z':ds_z.tr=triples[0]-1
 endcase
 endif
endif
;
dirs=['All','Selected','Next','Current','Previous']
;
; Channel selection
classes=['point','delay','bg','scan','uv','ncal','amoeba','seeing']
if long(where(classes eq class),0) ne -1 then begin
 dropch_wid=widget_droplist(datasel_wid,title='Channels:  ', $
	event_pro='ww_setchdir',value=dirs,uvalue=stream)
 widget_control,dropch_wid,set_droplist_select=3
 textch_wid=widget_text(datasel_wid,event_pro='ww_setchsel', $
	/editable,uvalue=stream)
 ch_dirs=dirs
endif
;
; Baseline selection
classes=['point','delay','scan','uv','amoeba','ncal','seeing']
if long(where(classes eq class),0) ne -1 then begin
 dropbl_wid=widget_droplist(datasel_wid,title='Baselines: ', $
	event_pro='ww_setbldir',value=dirs,uvalue=stream)
 widget_control,dropbl_wid,set_droplist_select=3
 textbl_wid=widget_text(datasel_wid,event_pro='ww_setblsel', $
	/editable,uvalue=stream)
 bl_dirs=dirs
endif
;
if 0 then begin	; work to allow multiple triple selection in progress
; Triple selection
classes=['point','scan','amoeba','ncal']
if long(where(classes eq class),0) ne -1 $
and max(GenInfo.NumTriple) gt 0 then begin
 triples=string(indgen(max(GenInfo.NumTriple))+1)
 count=0
 if class ne 'amoeba' then $
 index=where(total(scantable.station,fix(size(scantable.station),0)) eq 0,count)
 if count gt 0 then begin
  for i=0,genconfig.numtriple-1 do begin
   for j=0,count-1 do begin
    if strpos(strjoin(genconfig.baselineid[genconfig.triplebase[*,i], $
					   genconfig.triplebeam[*,i]],' '), $
	      genconfig.stationid[index[j]]) ge 0 then triples[i]=''
   endfor
  endfor
  index=where(strlen(triples) gt 0,count)
  if count gt 0 then triples=triples[index]
 endif
 if total(strlen(triples)) ne 0 then begin
 droptr_wid=widget_droplist(datasel_wid,title='Triples: ', $
	event_pro='ww_settrdir',value=dirs,uvalue=stream)
 widget_control,droptr_wid,set_droplist_select=3
 texttr_wid=widget_text(datasel_wid,event_pro='ww_settrsel', $
	/editable,uvalue=stream)
 tr_dirs=dirs
 endif
endif
endif
;
; Point/scan selection
classes=['delay','scan','uv','amoeba','metro','ncal','phot','seeing','volvox']
if long(where(classes eq class),0) ne -1 then begin
 values=dirs
 if class eq 'ncal' then values=[dirs,scanconfig()]
 if class eq 'scan' then values=[dirs,scanconfig(/coh)]
 if class eq 'seeing' then values=[dirs,scanconfig(/coh)]
 droppt_wid=widget_droplist(datasel_wid,title='Points:    ', $
	event_pro='ww_setptdir',value=values,uvalue=stream)
 widget_control,droppt_wid,set_droplist_select=0
 textpt_wid=widget_text(datasel_wid,event_pro='ww_setptsel', $
	/editable,uvalue=stream)
 pt_dirs=values
endif
;
widget_control,datasel_wid,/realize
xmanager,'ww_indexsel',datasel_wid,event_handler='ww_indexsel_refresh',/no_block
case stream of
	'x':x_shown=x_shown+1
	'y':y_shown=y_shown+1
	'z':z_shown=z_shown+1
endcase
end
