function ww_isoutilities,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common obs_data,ot,ote,ol,ole,do_obs
common iso_data,z,age,table,current_data,current_age
common aux_data,dotted_data,dashed_data,do_dotted,do_dashed
common interpol,l_d,c_d,l_i,c_i,l_a,c_a
;
case event.value of
	'Range':begin
	   	icom=set_boxes(box_x,box_y)
	   	if icom eq 4 then begin
  			!x.range=0
			!y.range=0
	   	endif else begin
			!x.range=[box_x[0],box_x[1]]
			!y.range=[box_y[3],box_y[4]]
	   	endelse
	   	end
	'Data' :begin
		if n_elements(do_obs) eq 0 then do_obs=0
		end
	'Hardcopy':begin
		plot_iso,'PS'
		end
	'Info' :begin
		if n_elements(table) eq 0 then begin
			print,'***Error: no table loaded!'
			return,-1
		endif
		index=where(fix(table.age*10+0.5) eq fix(current_age*10+0.5), $
			count)
		if count gt 0 then begin
			teff=table[index].teff
			lum =table[index].lum
;			mbol=table(index).mbol
			mass=table[index].mass
			mv=table[index].mv
			bv=table[index].bv
			x=double(teff*!x.s[1]+!x.s[0])*640
			y=double(lum *!y.s[1]+!y.s[0])*512
			cursor,xc,yc,/down,/device
			xc=double(xc)
			yc=double(yc)
			dist=sqrt((x-xc)^2+(y-yc)^2)
			i=where(dist eq min(dist))
			i=i[0]
			j=i+1
			label1:
			v1=[x[j]-x[i],y[j]-y[i]]
			v2=[xc-x[i],yc-y[i]]
			v1l=sqrt(v1[0]^2+v1[1]^2)
			dl=(v1[0]*v2[0]+v1[1]*v2[1])/v1l
			if dl lt 0 and j eq i+1 then begin
				j=i-1
				goto,label1
			endif
			dx=v1[0]/v1l*dl
			dy=v1[1]/v1l*dl
;
			if n_elements(c_i) eq 0 then c_i=0
			l_i=c_i
			c_i=i
			if n_elements(c_d) eq 0 then c_d=0
			l_d=c_d
			c_d=current_data
			if n_elements(c_a) eq 0 then c_a=0
			l_a=c_a
			c_a=current_age
;
			tvx=x[i]+dx
			tvy=y[i]+dy
			tvcrs,tvx,tvy,/device
			teff_int=(teff[j]-teff[i])/v1l*dl+teff[i]
			lum_int=(lum[j]-lum[i])/v1l*dl+lum[i]
;			mbol_int=(mbol(j)-mbol(i))/v1l*dl+mbol(i)
			mv_int=(mv[j]-mv[i])/v1l*dl+mv[i]
			bv_int=(bv[j]-bv[i])/v1l*dl+bv[i]
			mass_int=(mass[j]-mass[i])/v1l*dl+mass[i]
			lum_ml=-0.021828336 $
                               +4.5336284*alog10(mass_int) $
                               -0.62450534*alog10(mass_int)^2
mbol_int=0
			print,'T=',10^teff_int,', L=',10^lum_int, $
				', M_b=',mbol_int, $
				', M_V=',mv_int,', B-V=',bv_int, $
				', M=',mass_int,', L_ML=',10^lum_ml, $
			format='(a,f6.0,a,f8.1,a,f5.2,a,f5.2,a,f5.2,a,f5.2,a,f8.1)'
		endif
		end
	'Interpolate' :begin
		il=where(table.age eq l_a,count_l)
		table_l=table[il]
		ic=where(table.age eq c_a,count_c)
		table_c=table[ic]
		num_1=min([l_i,c_i])
		num_2=min([count_l-l_i,count_c-c_i])
		num=num_1+num_2
		teff_l=table_l[l_i-num_1:l_i+num_2-1].teff
		lum_l=table_l[l_i-num_1:l_i+num_2-1].lum
		mbol_l=table_l[l_i-num_1:l_i+num_2-1].mbol
		mass_l=table_l[l_i-num_1:l_i+num_2-1].mass
		mv_l=table_l[l_i-num_1:l_i+num_2-1].mv
		bv_l=table_l[l_i-num_1:l_i+num_2-1].bv
		teff_c=table_c[c_i-num_1:c_i+num_2-1].teff
		lum_c=table_c[c_i-num_1:c_i+num_2-1].lum
		mbol_c=table_c[c_i-num_1:c_i+num_2-1].mbol
		mass_c=table_c[c_i-num_1:c_i+num_2-1].mass
		mv_c=table_c[c_i-num_1:c_i+num_2-1].mv
		bv_c=table_c[c_i-num_1:c_i+num_2-1].bv
		num_i=9
		num_t=n_elements(table)
		num_n=num_t+num_i*num
		aget=fltarr(num_n) & aget[0:num_t-1]=table.age
		teff=fltarr(num_n) & teff[0:num_t-1]=table.teff
		lum=fltarr(num_n) & lum[0:num_t-1]=table.lum
		mbol=fltarr(num_n) & mbol[0:num_t-1]=table.mbol
		mass=fltarr(num_n) & mass[0:num_t-1]=table.mass
		mv=fltarr(num_n) & mv[0:num_t-1]=table.mv
		bv=fltarr(num_n) & bv[0:num_t-1]=table.bv
		age_step=float(fix((c_a-l_a)*100+0.5))/100/(num_i+1)
		for i=0,num_i-1 do begin
			aget[num_t+i*num:num_t+(i+1)*num-1]= $
			 (i+1)*age_step+l_a
			teff[num_t+i*num:num_t+(i+1)*num-1]= $
			 (teff_c-teff_l)/(c_a-l_a)*(i+1)*age_step+teff_l
			lum[num_t+i*num:num_t+(i+1)*num-1]= $
			 (lum_c-lum_l)/(c_a-l_a)*(i+1)*age_step+lum_l
			mbol[num_t+i*num:num_t+(i+1)*num-1]= $
			 (mbol_c-mbol_l)/(c_a-l_a)*(i+1)*age_step+mbol_l
			mass[num_t+i*num:num_t+(i+1)*num-1]= $
			 (mass_c-mass_l)/(c_a-l_a)*(i+1)*age_step+mass_l
			mv[num_t+i*num:num_t+(i+1)*num-1]= $
			 (mv_c-mv_l)/(c_a-l_a)*(i+1)*age_step+mv_l
			bv[num_t+i*num:num_t+(i+1)*num-1]= $
			 (bv_c-bv_l)/(c_a-l_a)*(i+1)*age_step+bv_l
		endfor
		table=build_table['aget age, teff, lum, mbol, mass, mv, bv']
		end
	'Dotted':begin
		dotted_data=current_data
		if do_dotted then do_dotted=0 else do_dotted=1
		end
	'Dashed':begin
		dashed_data=current_data
		if do_dashed then do_dashed=0 else do_dashed=1
		end
endcase
end
