function ww_jacobylines,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common PlotJacoby,jacoby_wid,stars,fluxes,lambda
;
max_flux=max(fluxes)
;
case event.value of
	'H':	lines=[6563,4861,4340,4102,3970,3889,3835,3798,3771]
	'Sun':	lines=[3968,3934,4102,4227,4300,4384,4861,5167,5173,5184, $
		       5270,5890,5896,6563]
	'Mg I':	lines=[5167,5173,5184]
	'Mg II':lines=[4481]
	'Na I':	lines=[5890,5896]
	'Fe I':	lines=[5270,4405,4384,4325,4045]
	'Ca I':	lines=[4227,4425,4435,4455]
	'Ca II':lines=[3968,3934]
	'CH':	lines=[4300]
	'CN':	lines=[3888,4215]
	'He I':	lines=[3819,4009,4026,4144,4387,4471,6678]
	'He II':lines=[4100,4200,4340,4542,4686]
	'Ti II':lines=[4444]
	'Sr II':lines=[4077]
	'Cr I': lines=[4254,4275]
	'TiO':	lines=[4584,4761,4954,5167,5448,5595,6159,6651,7054]
	'O_2':	lines=[6867]
		else:	begin
			print,'***Error(WW_LINES): invalid choice!'
			return,-1
			end
endcase
for i=0,n_elements(lines)-1 do begin
	dlambda=abs(lambda-lines[i])
	index=where(dlambda eq min(dlambda))
	max_y=fluxes[index[0]]*0.9
	oplot,[lines[i],lines[i]],[0,max_y],psym=0,linestyle=0
endfor
;
end
