pro ww_listcalreasons,command
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Widget to display list of cal reasons from which is to be selected a
; calibration for editing or removal. (Not a callback function.)
;
common WwListCalReasons,listcalreasons_wid
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
;
if n_elements(listcalreasons_wid) eq 0 then listcalreasons_wid=0L
if listcalreasons_wid ne 0 then widget_control,listcalreasons_wid,/destroy
;
list_calreasons,reasons
if reasons[0] eq '' then begin
	print,'***Error(WW_LISTCALREASONS): no entries found!'
	return
endif
if n_elements(command) eq 0 then return
case command of
	'Edit':callback='ww_editcal'
	'Undo':callback='ww_undocal'
	else:return
endcase
variable=cal_options.n[cal_options.v]
listcalreasons_wid=widget_base(kill_notify='ww_listcaldestroyed', $
	resource_name='oyster', $
	title='Calreasons('+variable+')',xoffset=0,yoffset=0)
list_wid=widget_list(listcalreasons_wid,value=reasons,uvalue=reasons, $
	event_pro=callback,ysize=6)
;
widget_control,listcalreasons_wid,/realize
xmanager,'ww_listcalreasons',listcalreasons_wid,/no_block
;
end
