pro ww_loadmetrosel,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Callback for Load metrology button in ACCESS button.
;
common LoadMetroInfo,motiongroup,astromgroup,loadmetrosel_wid
;
get_datum,date
if date[0] eq '' then return
;
; At least one motion group must be present
get_nummotiongroup,n
if n eq 0 then begin
	print,'***Error(WW_LOADMETROSEL): no data!'
	return
endif
motiongroups=string(indgen(n)+1)
;
; An AstromCorGrp is not necessarily present
get_numastromcorgrp,n
if n gt 0 then astromgroups=string(indgen(n)+1)
;
; Close any existing metro widget
if n_elements(loadmetrosel_wid) eq 0 then loadmetrosel_wid=0L
if loadmetrosel_wid ne 0 then widget_control,loadmetrosel_wid,/destroy
;
loadmetrosel_wid=widget_base(title=date,kill_notify='ww_loadmetrodestroyed', $
			xoffset=580,yoffset=10,/column,resource='oyster')
;
text_wid=widget_text(loadmetrosel_wid,value=' Motion group selection: ')
motn_wid=widget_list(loadmetrosel_wid,value=motiongroups,uvalue='motion', $
	event_pro='ww_loadmetro',ysize=n_elements(motiongroups))
;
if n_elements(astromgroups) gt 0 then begin
text_wid=widget_text(loadmetrosel_wid,value=' Astrom group selection: ')
astm_wid=widget_list(loadmetrosel_wid,value=astromgroups,uvalue='astrom', $
	event_pro='ww_loadmetro',ysize=n_elements(astromgroups))
endif
;
widget_control,loadmetrosel_wid,/realize
xmanager,'ww_loadmetrosel',loadmetrosel_wid,/no_block
;
end
