pro ww_loadsplib,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common PlotSplib,splib_wid,stars,fluxes,lambda
;
num_fluxes=2799
;
star=stars[event.index]
index=where(stars eq star[0],count)
if count eq 1 then begin
	fluxes=fltarr(num_fluxes)
	status=linknload(!external_lib,'splib',index,fluxes)
	lambda=findgen(num_fluxes)*1.4+3510.0
        fluxes=fluxes/avg(fluxes)
;	fluxes=fluxes*1.0e12
	if !d.name eq 'NULL' then begin
		openw,unit,'fluxes.dat',/get_lun
		for i=0,num_fluxes-1 do printf,unit,lambda[i],fluxes[i]
		free_lun,unit
	endif else begin
	plot,lambda,fluxes,charsize=1.5,xstyle=1,xticklen=0.05, $
		title=star[0],xtitle='lambda [Angstroems]',ytitle='Flux', $
		psym=0,linestyle=0
		f_u=total(johnson_u(lambda/10)*fluxes) $
		   /total(johnson_u(lambda/10))
		f_b=total(johnson_b(lambda/10)*fluxes) $
		   /total(johnson_b(lambda/10))
		f_v=total(johnson_v(lambda/10)*fluxes) $
		   /total(johnson_v(lambda/10))
		f_r=total(johnson_r(lambda/10)*fluxes) $
		   /total(johnson_r(lambda/10))
		f_i=total(johnson_i(lambda/10)*fluxes) $
		   /total(johnson_i(lambda/10))
; 		m_u=-2.5*alog10(f_u)-magfilter('U') ; not far enough to U band
		m_b=-2.5*alog10(f_b)-magfilter('B')
		m_v=-2.5*alog10(f_v)-magfilter('V')
		m_r=-2.5*alog10(f_r)-magfilter('R')
		m_i=-2.5*alog10(f_i)-magfilter('I')
; 		print,'(U-B) = ',m_u-m_b
		print,'(B-V) = ',m_b-m_v
		print,'(R-I) = ',m_r-m_i
;
;	Overplot stellar atmosphere (testing purposes)
	w=nameparse(star)
	if n_elements(w) eq 3 and strlen(w[0]) gt 5 then sptype=w[1]+w[2]
	if n_elements(w) eq 3 and strlen(w[0]) le 5 then sptype=w[2]
	if n_elements(w) eq 4 then sptype=w[2]+w[3]
	r=limbgrid(teff_star(sptype),logg_star(sptype),l,u,f) & l=l*10
	y=spline(l,f,lambda)
	i=where(l ge min(lambda) and l le max(lambda))
	r=total(fluxes)/total(y)
	oplot,lambda,y*r,color=tci(3)
	endelse
endif
;
end
