pro ww_loadstar,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Callback for Load star button in ACCESS button. Creates window with widget
; listing the stars contained in data base.
; Widget is intended to stay active throughout the loading/editing
; /averaging stage of CHAMELEON.
;
common LoadStarInfo,selstars,loadstar_wid
;
get_datum,date
if date[0] eq '' then return
selstars=''
list_stars,stars
if stars[0] eq '' then return
;
if n_elements(loadstar_wid) eq 0 then loadstar_wid=0L
if loadstar_wid ne 0 then widget_control,loadstar_wid,/destroy
;
loadstar_wid=widget_base(/row,kill_notify='ww_loadstardestroyed', $
			title=date,xoffset=568,yoffset=0,resource='oyster')
list_wid=widget_list(loadstar_wid,value=stars,uvalue=stars, $
	event_pro='ww_loadstarsel', $
	ysize=n_elements(stars),/multiple)
button_wid=cw_bgroup(loadstar_wid,['All stars','HELP','Load'],/column, $
	event_funct='ww_loadstarok',uvalue=list_wid,/return_name)
;
widget_control,loadstar_wid,/realize
xmanager,'ww_loadstar',loadstar_wid,/no_block
;
end
