pro ww_loadtlusty,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common PlotTlusty,files_wid,files,teffs,loggs,teff,logg,vsini,deltam
;
forward_function lsf_rotate
;
if event.sel_left lt 0 then return
;
logg=loggs[event.sel_top]
teff=teffs[event.sel_left]
files=findfile(!atmospheres_dir+'tlusty/*.vis.7.gz')
index=where(strpos(specname(files),teff) eq 1 $
	and strpos(specname(files),logg) eq 7,count)
if count eq 1 then file=files[index[0]] else return
xdr_file=findfile(strmid(file,0,strpos(file,'.gz'))+'.xdr')
if strlen(xdr_file[0]) gt 0 then restore,xdr_file[0] else $
			status=dc_read_free(file,lambda,flux,/col)
r=poly_fit(lambda,flux,2,yfit)
x=lambda
y=flux/yfit
if float(vsini) gt 0 and (!x.range[1]-!x.range[0]) le 200 then begin
	index=where(x gt !x.range[0] and x lt !x.range[1])
	velgrid=3e5*(x[index]/(total(!x.range)/2)-1)
	deltav=median(velgrid-shift(velgrid,1))
	kernel=lsf_rotate(deltav,float(vsini),velgrid=vel)
;	wgrid=(total(!x.range)/2)*(1+vel/3e5)
	y=1-convol(1-y,kernel)/n_elements(kernel)
endif
f1=1.0
f2=10^(-deltam/2.5)
plot,x,(f1+f2*y)/(f1+f2),psym=0,title=file
;
return ; The code following is obsolete
;
file=files[event.index]
xdr_file=findfile(file+'.xdr')
if strlen(xdr_file[0]) gt 0 then restore, xdr_file[0] else $
			status=dc_read_free(file,lambda,flux,/col)
r=poly_fit(lambda,flux,2,yfit)
plot,lambda,flux/yfit,psym=0,title=file
;
end
