function ww_magselok,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common FileSelInfo,file_dir,file_sel,sel_file,file_ext
common ModelFit,parameters,ds_options
common WwDataSel,opmenul_wid,opmenuw_wid,opmenua_wid,opmenup_wid,opmenuf_wid
common LocalMagSel,magfiles
;
case event.value of
'OK':	begin
	files=''
	case file_dir of
		'All'	:files=findfile('*.mag')
		'File'  :begin
			 if n_elements(sel_file) eq 0 then begin
			  	print,'***Error(WW_MAGSELOK): file unspecified!'
			 	return,-1
			 endif
			 result=findfile(sel_file,count=fcount)
			 if fcount eq 0 then begin
			  	print,'***Error(WW_MAGSELOK): file not found!'
			  	return,-1
			 endif
			 if strpos(sel_file,'.mag') ne -1 then $
				files=sel_file else begin
			 status=dc_read_fixed(sel_file,files,resize=[1], $
			  	format='(a)',/col)
			 if status ne 0 then begin
				print,'***Error(WW_MAGSELOK): error reading file!'
				return,-1
			 endif
			 endelse
			 end
		'List'  :if n_elements(file_sel) ne 0 then files=file_sel
	endcase
	if strlen(strcompress(files[0],/remove_all)) eq 0 then begin
		print,'***Error(WW_MAGSELOK): no files specified!'
		return,-1
	endif
	load_photometry,files
	magfiles=files
	if ds_options.pm eq 0 then $
	widget_control,opmenuw_wid,set_droplist_select=1
	if ds_options.pm eq 1 then $
	widget_control,opmenuw_wid,set_droplist_select=3
     	end
'HELP':	begin
	print,'________________________________________'
	print,'Select from files displayed in the list.'
	print,'These should contain measured magnitudes'
	print,'for multiple star systems. Load options:'
	print,'All:  read all files listed.            '
	print,'File: read specified file for file list.'
	print,'List: read files selected in list.      '
	print,'Type: default is "Phot" for light curves'
	print,'  "Model" for variable binary components'
	print,'_________________***____________________'
	end
endcase
;
end
