pro ww_marquardtfit
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common AmoebaWids,data_wid,modelfit_wid,ifit_wid,afit_wid,control_wid
common MarquardtFit,fit_options
;
; Return if widget is already displayed
if n_elements(control_wid) eq 0 then control_wid=0
if control_wid ne 0 then return
;
; Initialize options
if init_marquardtfit() ne 0 then return
;
; Create the widget
control_wid=widget_base(kill_notify='ww_marquardtfitdestroyed', $
	resource_name='oyster', $
	xoffset=!dxsize-500,yoffset=0,/column,title='FitControl')
;
; Fit options
label_wid=widget_label(control_wid,value='Fit options')
options=['One','Float','Opt.']
button_wid=cw_bgroup(control_wid,options,/nonexclusive,column=3, $
	event_funct='ww_marquardtfitoptions')
;
; Fit control parms (see also p. 684 of "Numerical Recipes in C", 2nd ed.)
alamda=['1.0','0.1','0.01','0.001']
opmenual_wid=widget_droplist(control_wid,title='Lambda:       ', $
	event_pro='ww_setalamda',value=alamda,uvalue=alamda)
widget_control,opmenual_wid,set_droplist_select=2
;
tolerance=['1e-4','1e-5','1e-6','1e-7','1e-8','1e-9','1e-10']
opmenuth_wid=widget_droplist(control_wid,title='Tolerance:    ', $
	event_pro='ww_settolerance',value=tolerance,uvalue=tolerance)
widget_control,opmenuth_wid,set_droplist_select=2
;
chifr=['0.1','0.01','0.001','0.0001']
opmenuch_wid=widget_droplist(control_wid,title='Convergence: ', $
	event_pro='ww_setchifr',value=chifr,uvalue=chifr)
widget_control,opmenuch_wid,set_droplist_select=2 ; must correspond to alloc
;
helpt=['Lambda','Tolerance','Convergence']
opmenuhp_wid=widget_droplist(control_wid,title='Help:   ', $
	event_pro='ww_getlmhelp',value=helpt,uvalue=helpt)
widget_control,opmenuhp_wid,set_droplist_select=1
;
widget_control,control_wid,/realize
xmanager,'ww_marquardtfit',control_wid,/no_block
;
end
