pro ww_modelfit
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; GUI for the model fits to combined data.
;
common AmoebaWids,data_wid,modelfit_wid,ifit_wid,afit_wid,control_wid
common WwFitWids,list1_wids,list2_wids
common ModelFit,parameters,ds_options
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
; Check for existence of model
if n_elements(gen_model) eq 0 then begin
	print,'***Error(WW_MODELFIT): no model loaded!'
	return
endif
;
; Check for resolved flux component
index=where(star_model.type eq 0,n)
if n ne 0 then begin
	print,'Model has resolved flux component!'
	print,'Its value must be set manually, e.g.:'
	print,'star_model['+strcompress(string(n+1),/remove_all) $
		+'].magnitudes= ', $
		strcompress(string(float(star_model[index[0]].magnitudes)), $
		/remove_all)
endif
;
; Return if widget is already displayed
if n_elements(modelfit_wid) eq 0 then modelfit_wid=0
if modelfit_wid ne 0 then begin
	print,'FitWidget is already displayed!'
	return
endif
;
; Create array to hold widget IDs of parameter lists
; list1 is for orbital parameters, list2 for relative comp. positions
if n_elements(list1_wids) eq 0 then list1_wids=lonarr(num_binary()+1)
if n_elements(list2_wids) eq 0 then list2_wids=lonarr(num_binary()+1)
;
; Initialize/reset options (disabled 12.12.2023 and moved to readmodel)
if n_elements(parameters) eq 0 then begin
	if init_modelfit() ne 0 then begin
		print,'No model loaded!'
		return
	endif
endif
;
; Create the widget
modelfit_wid=widget_base(kill_notify='ww_modelfitdestroyed', $
	resource_name='oyster', $
	/row,title='ModelFit',xoffset=!dxsize-183,yoffset=0)
column1_wid=widget_base(modelfit_wid,/column)
column2_wid=widget_base(modelfit_wid,/column)
;
; 	General model
	component=systemcomp()
	gen_wid=widget_base(column1_wid,/column,/frame)
;	label_wid=widget_label(gen_wid,value=component)
	button_wid=widget_button(gen_wid,value=component,event_func='ww_modellist')
	list_wid=widget_list(gen_wid, $
		value=genparms(),uvalue={c:component,p:genparms()}, $
		event_pro='ww_modelfitparameters', $
		/multiple,ysize=n_elements(genparms()))
;
for i=0,num_star()-1 do begin
;	Star models
	component=star_model[i].component
	label=star_model[i].component+' ('+star_model[i].wmc+')'
	star_wid=widget_base(column1_wid,/column,/frame)
;	label_wid=widget_label(star_wid,value=component)
	button_wid=widget_button(star_wid,value=label,event_func='ww_modellist')
	list_wid=widget_list(star_wid, $
		value=starparms(),uvalue={c:component,p:starparms()}, $
		event_pro='ww_modelfitparameters', $
		/multiple,ysize=n_elements(starparms()))
endfor
;
for i=0,num_binary()-1 do begin
;	Binary models
	component=binary_model[i].component
	bin_wid=widget_base(column2_wid,/column,/frame)
;	label_wid=widget_label(bin_wid,value=component)
	button_wid=widget_button(bin_wid,value=component, $
		uvalue=binary_model[i].method, $
		event_func='ww_modellist')
	list_wid=widget_list(bin_wid, $
		value=binparms(),uvalue={c:component,p:binparms()}, $
		event_pro='ww_modelfitparameters', $
		/multiple,ysize=n_elements(binparms()))
	list1_wids[i]=list_wid
endfor
;
button_wid=cw_bgroup(column1_wid,['Fit','ChiSq','Error'], $
	event_funct='ww_modelfitok',/return_name,/row)
button_wid=cw_bgroup(column1_wid,['Help','Opt'], $
	event_funct='ww_modelfitok',/return_name,/row)
;
widget_control,modelfit_wid,/realize
xmanager,'ww_modelfit',modelfit_wid,/no_block
;
;
end
