function ww_modelfitok,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common ModelFit,parameters,ds_options
common LocalChaSel,chafiles
common LocalFitSel,oiffiles
common LocalPsnSel,psnfiles
common LocalVelSel,velfiles
common LocalMagSel,magfiles
;
case event.value of
	'Fit': 	begin
		print,'Beginning NLLSQ fitting...'
		fitmodel
		end
	'ChiSq':begin
		marquardtdata,y,ysig,ymod
		if total(ysig) eq 0 then return,-1
		chisq=total(((y-ymod)/ysig)^2)/n_elements(y)
		print,'Reduced Chi-Squared = ',chisq
		print,'Number of data points:',n_elements(y)
		if !d.window ne -1 or !d.name eq 'PS' then $
		histograph,(y-ymod)/ysig,min=-8,max=8,binsize=0.4, $
			xtitle=greek('sigma')+' deviation',chisq=chisq
		end
	'Error':begin
		print,'Estimating statistical errors...'
		fitmodel,/error
		end
	'Opt':	begin
		file=file_search('Z_h_steps.xdr')
		answer='Yes'
		if strlen(file) ne 0 then answer= $
		dialog_message('Z_h_steps exists. Overwrite?',/question)
		if answer ne 'Yes' then begin
			print,'OK, nothing to do.'
			return,0
		endif else file='Z_h_steps.xdr'
;		Check that data are loaded
		marquardtdata,y,ysig,ymod
		if total(ysig) eq 0 then begin
			print,'No data found!'
			return,-1
		endif
		print,'Computing optimal values for h (increments)...'
		set_h_steps,file
;
		print,'Reading data again, as they have been overwritten...'
		if ds_options.i then begin
		  if n_elements(chafiles) ne 0 then $
		  if strlen(chafiles[0]) ne 0 then load_interferometry,chafiles
		  if n_elements(oiffiles) ne 0 then $
		  if strlen(oiffiles[0]) ne 0 then load_interferometry,oiffiles
		endif
		if ds_options.a then load_astrometry,psnfiles
		if ds_options.s then load_spectroscopy,velfiles
		calcmodel
		print,'Click component labels to examine step sizes.'
		end
	'Help':	begin
		print,'________________________________________________'
		print,'GUI to fit a hierarchical stellar model. To fit'
		print,'Rho/Theta, select them in Fit/Interferometry!'
		print,'Select parameters to fit, then click on "Fit".'
		print,'To fit rho/theta to vis. data, select these in'
		print,'the FitInterferometry GUI but click "Fit" here!'
		print,'Compute statistical errors with button "Error".'
		print,'Opt computes optimal step sizes for Marquardt-'
		print,'Levenberg for the currently loaded data.'
		print,'To use the opt. steps, select Opt in FitControl.'
		print,'(Interferometric data have to be reloaded after'
		print,'running Opt.)'
		print,'______________________***_______________________'
		end
endcase
;
end
