pro ww_pivot
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ChameleonWids,plot_wid,td_wid,cal_wid,astrom_wid,pivot_wid,triple_wid
;
; Create a widget tool to play with catseye pivot point offsets.
; Last values obtained are: p_C = -4 mu, p_E = +12 mu, p_W = +43 mu
;
if checkdata([8]) ne 0 then return
;
; Create this widget if necessary to set astrometry fit parameters
if n_elements(astrom_wid) eq 0 then astrom_wid=0L
if astrom_wid eq 0 then ww_astromsolve
;
; Plot control is through this widget
if n_elements(plot_wid) eq 0 then plot_wid=0L
if plot_wid eq 0 then begin
	if init_plot('astrom','pt') ne 0 then return
endif
;
; Remove any existing widget
if n_elements(pivot_wid) eq 0 then pivot_wid=0L
if pivot_wid ne 0 then widget_control,pivot_wid,/destroy
;
xs=long(!xsize)
ys=long(!ysize)
pivot_wid=widget_base(title='Pivot tool',/column, $
			resource_name='oyster', $
                       	kill_notify='ww_pivotdestroyed')
;
drawing_wid=widget_draw(pivot_wid,notify_realize='ww_pivotcorr', $
		scr_xsize=xs,scr_ysize=ys)
;
for i=0,GenConfig.NumSid-1 do begin
	label=GenConfig.StationId[i] $
     	     +' Catseye center - mirror offset [mu]'
	control_wid=widget_slider(pivot_wid,title=label, $
		minimum=-50,maximum=50,event_pro='ww_pivotcorr', $
        	xsize=xs,value=0,uvalue=string(i+1))
endfor
;
widget_control,pivot_wid,/realize
xmanager,'ww_pivot',pivot_wid,/no_block
;
end
