pro ww_plot
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Displays the main interferometry plot widget.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PlotWids1,dropy_wid,dropx_wid,dropsl_wid
common PlotWids2,dropst_wid,listst_wid,dropnt_wid,option_wid
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common DataSelWids,x_wid,x_shown,y_wid,y_shown,z_wid,z_shown
common ChameleonWids,plot_wid,td_wid,cal_wid,astrom_wid,pivot_wid,triple_wid
common StarBase,StarTable,Notes
common LocalWwPlotRefresh,offsety,offseti,offsetd
;
; Check status of currently displayed widgets
if n_elements(x_shown) eq 0 then x_shown=0
if n_elements(y_shown) eq 0 then y_shown=0
if n_elements(z_shown) eq 0 then z_shown=0
if x_shown then widget_control,x_wid,/destroy
if y_shown then widget_control,y_wid,/destroy
if z_shown then widget_control,z_wid,/destroy
;
if n_elements(plot_wid) eq 0 then plot_wid=0L
if plot_wid ne 0 then widget_control,plot_wid,/destroy
;
; Check status of class
if n_elements(class) eq 0 then begin
	print,'***Error(WW_PLOT): no class specified!'
	return
endif
;
; Check data
case class of
	'point' :if checkdata([1,11]) ne 0 then return
	'delay' :if checkdata([1,11]) ne 0 then return
	'bg'    :if checkdata([1,2,3,10]) ne 0 then return
	'scan'  :if checkdata([1,9]) ne 0 then return
	'ncal'  :if checkdata([1,9]) ne 0 then return
	'phot'  :if checkdata([1,9]) ne 0 then return
	'astrom':if checkdata([1,9]) ne 0 then return
	'seeing':if checkdata([1]) ne 0 then return
	'metro' :if checkdata([16]) ne 0 then return
	'uv'    :if checkdata([9]) ne 0 then return
	'amoeba':if checkdata([13,14]) ne 0 then return
	'volvox':if checkdata([12,13,14]) ne 0 then return
	    else:begin
		 print,'***Error(WW_PLOT): unknown class: ',class
		 return
		 end
endcase
;
; Create the widget
case class of
	'point' :title='PointPlot'
	'delay' :title='DelayPlot'
	'bg'    :title='BgPlot'
	'scan'  :title='VisibilityPlot'
	'ncal'  :title='CalibrateSystem'
	'phot'  :title='Photometry'
	'astrom':title='AstrometryPlot'
	'seeing':title='SeeingPlot'
	'metro' :title='MetrologyPlot'
	'uv'    :title='AmoebaUV'
	'amoeba':title='AmoebaXY'
	'volvox':title='AmoebaAstrom'
	    else:begin
		 print,'***Error(WW_PLOT): unknown class: ',class
		 return
		 end
endcase
offsety=10
;plot_wid=widget_base(/column,title=title,kill_notify='ww_plotdestroyed', $
;			resource_name='oyster', $
;			xoffset=130,yoffset=offsety,/kbrd_focus_events)
plot_wid=widget_base(/column,title=title,kill_notify='ww_plotdestroyed', $
			resource_name='oyster', $
			xoffset=130,/kbrd_focus_events)
;
; Axis selection
classes=['point','delay','bg','uv','scan','astrom','seeing','phot','amoeba','met
if long(where(classes eq class),0) ne -1 then begin
 	ax_items=set_axitems(item_ids)
 	dropy_wid=widget_droplist(plot_wid,title='Y-axis:', $
		event_pro='ww_setyaxis',value=ax_items)
 	dropx_wid=widget_droplist(plot_wid,title='X-axis:', $
		event_pro='ww_setxaxis',value=ax_items)
 	if class ne 'uv' then $
 	dropz_wid=widget_droplist(plot_wid,title='Z-axis:', $
		event_pro='ww_setzaxis',value=ax_items)
endif
;
; Type selection
classes=['ncal']
if long(where(classes eq class),0) ne -1 then begin
	types=['V2Bias','TABias','APDFlux','Response','TrackJitter','TrackOffset']
	dropty_wid=widget_droplist(plot_wid,title='Type: ', $
		event_pro='ww_settype',value=types,uvalue=types)
	widget_control,dropty_wid,set_droplist_select=0
	type=types[0]
endif
;
; Slice and Preset selection
classes=['delay','scan','amoeba']
if long(where(classes eq class),0) ne -1 then begin
	row_wid=widget_base(plot_wid,/row)
 	slices=['ib','ob','tr','ch','bl','pt']
 	dropsl_wid=widget_droplist(row_wid,title='Slice: ', $
		event_pro='ww_setslice',value=slices,uvalue=slices)
 	widget_control,dropsl_wid,set_droplist_select=5
	presets=['Preset','V_cal','V_pt','V_ch','TA_ch','TP_ch']
 	droppr_wid=widget_droplist(row_wid, $
		event_pro='ww_setpreset',value=presets,uvalue=presets)
endif
;
; Star selection
classes=['point','delay','bg','scan','uv','astrom','seeing','ncal','phot','amoeb
if long(where(classes eq class),0) ne -1 then begin
 	stars=['All','Cal','Sci','Sel']
	row_wid=widget_base(plot_wid,/row)
 	dropst_wid=widget_droplist(row_wid,title='Stars: ', $
		event_pro='ww_setstdir',value=stars,uvalue=stars)
 	sh_wid=widget_button(row_wid,value='Show',event_pro='ww_indexst')
 	up_wid=widget_button(row_wid,value='Update',event_pro='ww_updatest')
 	if class eq 'amoeba' or class eq 'uv' then stars=startable.starid $
					      else list_stars,stars
	names=strarr(n_elements(stars))
;	Special feature for IR/MIR observations: list IRAS targets
	if !owner eq 'chummel' then begin
		iras_stars=strarr(n_elements(stars))
		ra=dblarr(n_elements(stars))
		dec=dblarr(n_elements(stars))
		for i=0,n_elements(stars)-1 do begin
			j=where(startable.starid eq stars[i])
			ra[i]=startable[j].ra
			dec[i]=startable[j].dec
		endfor
		iras_stars='IRAS'+irasid(ra,dec)
	endif
	for i=0,n_elements(stars)-1 do begin
		j=where(stars[i] eq startable.starid) & j=j[0]
		names[i]=strtrim(startable[j].name,2)
		if !owner eq 'chummel' and $
			strpos(instrument_id(systemid),'MATISSE') ge 0 $
		then begin
			names[i]=iras_stars[j]
			if strlen(names[i]) eq 0 then $
				names[i]=strtrim(startable[j].name,2)
		endif
	endfor
 	listst_wid=widget_list(plot_wid,/multiple,ysize=3, $
		event_pro='ww_setstarsel', $
		value=stars+' ('+names+')',uvalue=stars)
	widget_control,up_wid,set_uvalue=listst_wid
endif
;
; Night selection
classes=['amoeba','uv','volvox']
if long(where(classes eq class),0) ne -1 then begin
 	nights=['All','Sel']
 	dropnt_wid=widget_droplist(plot_wid,title='Nights:         ', $
		event_pro='ww_setntdir',value=nights,uvalue=nights)
 	widget_control,dropnt_wid,set_droplist_select=0
 	nights=GenInfo.date+' '+GeoInfo.systemid+' '+GenInfo.configid
 	listnt_wid=widget_list(plot_wid,value=nights,uvalue=nights, $
		event_pro='ww_setnightsel',/multiple,ysize=3,xsize=30)
endif
;
; Window size selection
classes=['point','delay','scan','amoeba']
if long(where(classes eq class),0) ne -1 then begin
 	wsizes=['500x400','640x512','800x640','1024x512','1792x1024','800x1024']
 	dropsz_wid=widget_droplist(plot_wid,title='Window:', $
		event_pro='ww_setwsize',value=wsizes,uvalue=wsizes)
 	widget_control,dropsz_wid,set_droplist_select=2
endif
!xsize=640
!ysize=512
;
; Menu selection
panel=widget_base(plot_wid,/row)
utils=widget_base(panel,/column)
plot_menu=['1\Plot\ww_plotok', $
	   '0\Screen', $
	   '0\File'];, $
;	   '4\Auto', $
;	   '2\Zero']
plot_menu_wid=cw_pdmenu(utils,plot_menu)
edit_menu=['1\Edit\ww_plotok', $
	   '0\Auto', $
	   '2\Zero']
edit_menu_wid=cw_pdmenu(utils,edit_menu)
util_menu=['1\Util\ww_plotutil', $
           '0\Edit', $
           '4\Window', $
           '0\Range', $
           '0\Mean', $
           '0\Identify', $
           '0\H-Line', $
           '0\V-Line', $
           '6\FIT']
util_menu_wid=cw_pdmenu(utils,util_menu)
clear_button_wid=widget_button(utils,value='Clear',event_pro='ww_plothelp')
help_button_wid=widget_button(utils,value='HELP',event_pro='ww_plothelp')
;
options=['Errors', $
	 'Flagged', $
	 'Lines', $
	 'All in 1', $
	 '3D','Image', $
	 'NoFIR', $
	 'NoSort', $
	 'NoTrace', $
	 'All OBs', $
	 'All IBs', $
	 'Model', $
	 'Color', $
	 'Smooth', $
	 'Paper', $
	 'Custom']
option_wid=cw_bgroup(panel,column=2,options,/nonexclusive, $
 			event_funct='ww_plotoptions')
;
; Display plot widget
widget_control,plot_wid,/realize
widget_control,plot_wid,yoffset=offsety+1
xmanager,'ww_plot',plot_wid,event_handler='ww_plotrefresh',/no_block
;
; Reset plot ranges
!x.range=0
!y.range=0
!z.range=0
;
; Call ww_indexsel for classes which require data selection in any case
if class eq 'uv' then ww_indexsel,{top:plot_wid},'y'
if class eq 'ncal' then ww_indexsel,{top:plot_wid},'y'
;
end
