pro ww_plotmag
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plots magnitudes from photometry.
;
common WwPlotMag,plotmag_wid,plotmag_shown
common PlotMag,plotmag_options
;
; Check status of currently displayed widgets
if n_elements(plotmag_shown) eq 0 then plotmag_shown=0
if plotmag_shown then return
;
; Initialize options
if init_plotmag() ne 0 then return
;
; Check data
list_magcomps,components
if strlen(components[0]) eq 0 then return
;
; Create the widget
plotmag_wid=widget_base(kill_notify='ww_plotmagdestroyed', $
	resource_name='oyster', $
	/column,title='PlotPhotometry',xoffset=0,yoffset=0)
;
; Component selection
opmenu_wid=widget_droplist(plotmag_wid,title='Component: ', $
	event_pro='ww_plotmagcomp',value=components,uvalue=components)
plotmag_options.component=components[0]
;
; Filter selection
list_filters,filters
opmenu_wid=widget_droplist(plotmag_wid,title='Filters:', $
	event_pro='ww_plotmagfilter',value=filters,uvalue=filters)
plotmag_options.filter=filters[0]
;
; Window size selection
wsizes=['400x400','600x600','800x800','1000x1000']
opmenusz_wid=widget_droplist(plotmag_wid,title='Window:    ', $
	event_pro='ww_setwsize',value=wsizes,uvalue=wsizes)
!xsize=400
!ysize=400
;
; Menu selection
panel=widget_base(plotmag_wid,/row)
utils=widget_base(panel,/column)
plot_menu=['1\Plot\ww_plotmagok', $
	   '0\Screen', $
	   '0\File']
plot_menu_wid=cw_pdmenu(utils,plot_menu)
util_menu=['1\Util\ww_plotmagutil', $
	   '0\Identify', $
	   '0\Window', $
	   '0\Range', $
	   '2\Edit']
util_menu_wid=cw_pdmenu(utils,util_menu)
clear_button_wid=widget_button(utils,value='Clear',event_pro='ww_plotmaghelp')
help_button_wid=widget_button(utils,value='HELP',event_pro='ww_plotmaghelp')
;
options=['Errors', $
	 'Flagged', $
	 'Phase', $
	 'Orbit', $
	 'Color', $
	 'Paper', $
	 'All in 1', $
	 'Residuals']
option_wid=cw_bgroup(panel,column=2,options,/nonexclusive, $
 			event_funct='ww_plotmagoptions')
;
; Display mag widget
widget_control,plotmag_wid,/realize
xmanager,'ww_plotmag',plotmag_wid,/no_block
plotmag_shown=plotmag_shown+1
;
; Reset plot ranges
!x.range=0
!y.range=0
!z.range=0
;
end
