pro ww_plotok,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Checks data selection when PLOT button is pressed in plot selection widget.
; Calls plot or edit routines if checks come out ok. Data type specifies
; which particular routines are called. Also dispatches 3D plot.
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common ChameleonWids,plot_wid,td_wid,cal_wid,astrom_wid,pivot_wid,triple_wid
common PlotUtilWids,base_wid,list_wids
common LocalWwPlotOk,i0
;
; Complete data selection, classes amoeba and uv checked separately
if class ne 'amoeba' and class ne 'uv' and class ne 'volvox' then begin
	if set_starsel() ne 0 then begin
		print,'***Error(WW_PLOTOK): invalid star selection!'
		return
	endif
	if set_indexsel('x') ne 0 then begin
		print,'***Error(WW_PLOTOK): invalid x-data selection!'
		return
	endif
	if set_indexsel('y') ne 0 then begin
		print,'***Error(WW_PLOTOK): invalid y-data selection!'
		return
	endif
	if set_indexsel('z') ne 0 then begin
		print,'***Error(WW_PLOTOK): invalid y-data selection!'
		return
	endif
endif else if set_nightsel() ne 0 then begin
		print,'***Error(WW_PLOTOK): invalid night selection!'
		return
endif
;
; Remove any plot utility widgets
if n_elements(base_wid) eq 0 then base_wid=0L
if base_wid ne 0 then widget_control,base_wid,/destroy
;
; Deactivate 3D widget if present
if n_elements(td_wid) eq 0 then td_wid=0L
if td_wid ne 0 then widget_control,td_wid,sensitive=0
;
; Extract calling command
widget_control,event.id,get_value=command
;
; 3D plots
if ps_options.d and (not ps_options.m) and $
   (command ne 'Auto') and (command ne 'Zero') then ww_3D,event
;
; All other plotting/automatic editing
case command of
'Screen':begin
;	 set_plot,!display
	 set_screen
	 command='S/P'
	 end
'File'  :begin
	 words=nameparse(systime())
	 filename=strjoin(words[1:3],'-')+'.eps'
	 print,'Printing to file '+filename+'...'
	 set_ps,filename,color=ps_options.c
	 command='S/P'
	 end
else    :
endcase
;
case class of
'point' :begin
	 case command of
	 'Auto'  :plotdata,1,'AUTO'
	 'Zero'  :plotdata,2,'ZERO'
	 'S/P'   :plotdata
	 else    :print,'***Error(WW_PLOTOK): '+ $
				'choice not available!'
	 endcase
	 end
'delay' :begin
	 case command of
	 'Auto'  :plotdata,1,'AUTO'
	 'Zero'  :plotdata,2,'ZERO'
	 'S/P'   :plotdata
	 else    :print,'***Error(WW_PLOTOK): '+ $
	 		'choice not available!'
	 endcase
	 end
'bg'    :begin
	 case command of
	 'Zero'  :plotdata,2,'ZERO'
	 'S/P'   :plotdata
	 else    :print,'***Error(WW_PLOTOK): '+ $
	 		'choice not available!'
	 endcase
	 end
'scan'  :begin
	 case command of
	 'S/P'   :plotdata
	 else    :print,'***Error(WW_PLOTOK): '+ $
	 		'choice not available!'
	 endcase
	 end
'phot'  :begin
	 case command of
	 'S/P'   :plotdata
	 else    :print,'***Error(WW_PLOTOK): '+ $
	 		'choice not available!'
	 endcase
	 end
'ncal'  :begin
	 case command of
	 'S/P'   :plotncal
	 else    :print,'***Error(WW_PLOTOK): '+ $
	 		'choice not available!'
	 endcase
	 end
'astrom':begin
	 case command of
	 'S/P'   :plotdata
	 else    :print,'***Error(WW_PLOTOK): '+ $
	 		'choice not available!'
	 endcase
	 end
'seeing':begin
	 case command of
	 'S/P'   :plotdata
	 else    :print,'***Error(WW_PLOTOK): '+ $
	 		'choice not available!'
	 endcase
	 end
'uv0'    :begin
	 case command of
	 'S/P'   :plotuv
	 else    :print,'***Error(WW_PLOTOK): '+ $
	 		'choice not available!'
	 endcase
	 end
'metro' :begin
	 case command of
 	'Auto'  :plotdata,1,'AUTO'
	'S/P'   :plotdata
	else    :print,'***Error(WW_PLOTOK): '+ $
			'choice not available!'
	 endcase
	 end
'uv':begin
	 case command of
	 'S/P' :begin
		num_nights=n_elements(ds_nights)
		nob_mc_mb=size(scans[0].vissqc)
		if num_nights eq 1 and nob_mc_mb[1] eq 1 then do1=1 else do1=0
		if n_elements(i0) eq 0 then i0=0
		if num_nights gt 1 and $
			!d.name ne 'PS' and $
			not ps_options.a then $
		print,'More than one plot! Left click to continue, '+ $
			'middle to pause, right to exit!'
		overplot=0
;
		for i=i0,num_nights-1 do begin
			if strupcase(!version.os) ne 'WIN32' then $
			if n_elements(bufferinfo) gt 1 then $
				loadnight,ds_nights[i]
			flag=0
			!quiet=1
			if set_starsel() ne 0 then flag=1
			if set_indexsel('x',/quiet) ne 0 then flag=1
			if set_indexsel('y',/quiet) ne 0 then flag=1
			if set_indexsel('z',/quiet) ne 0 then flag=1
			!quiet=0
			if flag eq 0 then begin
			   if !d.name ne 'PS' then set_screen
			   if do1 then plotuv1,overplot=ps_options.a*overplot $
				  else plotuv,overplot=ps_options.a*overplot
			   overplot=overplot+1
			endif
			if num_nights gt 1 and i lt num_nights-1 $
				   	and !d.name ne 'PS' $
				   	and not ps_options.a then begin
				i0=0
				cursor,x,y
				wait,1
				if !mouse.button eq 2 then i0=i
				if !mouse.button ne 1 then return
			endif
		endfor
		end
	 else   :print,'***Error(WW_PLOTOK): '+ $
			'choice not available!'
	 endcase
	 end
'amoeba':begin
	 case command of
	 'S/P' :begin
		num_nights=n_elements(ds_nights)
		if n_elements(i0) eq 0 then i0=0
		if num_nights gt 1 and !d.name ne 'PS' and not ps_options.a then $
		print,'More than one plot! Left click to continue, '+ $
			'middle to pause, right to exit!'
		previous_window=!d.window
;
		for i=i0,num_nights-1 do begin
		if i eq i0 then overplot=1
		if strupcase(!version.os) ne 'WIN32' then $
		if n_elements(bufferinfo) gt 1 then loadnight,ds_nights[i]
		flag=0
		!quiet=1
		if set_starsel() ne 0 then flag=1
		if set_indexsel('x') ne 0 then flag=1
		if set_indexsel('y') ne 0 then flag=1
		if set_indexsel('z') ne 0 then flag=1
		!quiet=0
		if flag eq 0 then begin
		if !d.name ne 'PS' then set_screen
		if not ps_options.a then begin
			if !d.name ne 'PS' then wdall
			plotdata,overplot=0,status=status
			if !d.window ne -1 and !owner eq 'chummel' then begin
;			"Refresh" needed if running in virtual machine
;				wshow,iconic=1
;				wait,1
;				wshow,iconic=0
			endif
		endif else begin
			if !d.window eq -1 $
			or !d.window eq previous_window then plotdata $
							else plotdata,overplot=i
			status=0
		endelse
		if num_nights gt 1 and i lt num_nights-1 $
				   and status eq 0 $
				   and !d.window ne -1 $
				   and !d.name ne 'PS' $
				   and not ps_options.a then begin
			cursor,x,y,/down
;			wait,1
			if !mouse.button eq 2 then i0=i
			if !mouse.button ne 1 then return
			continue
		endif
		endif
		endfor
		end
'volvox':begin
	 case command of
	 'S/P' :begin
		num_nights=n_elements(ds_nights)
		if n_elements(i0) eq 0 then i0=0
		if num_nights gt 1 and !d.name ne 'PS' and not ps_options.a then $
		print,'More than one plot! Left click to continue, '+ $
			'middle to pause, right to exit!'
		for i=i0,num_nights-1 do begin
			if strupcase(!version.os) ne 'WIN32' then $
			if n_elements(bufferinfo) gt 1 then loadnight,ds_nights[i]
			flag=0
			if set_starsel() ne 0 then flag=1
			if set_indexsel('x') ne 0 then flag=1
			if set_indexsel('y') ne 0 then flag=1
			if set_indexsel('z') ne 0 then flag=1
			if flag eq 0 then begin
				if !d.name ne 'PS' then set_screen
				plotdata,overplot=ps_options.a*(i<1)
			endif
			if num_nights gt 1 and i lt num_nights-1 $
					   and !d.name ne 'PS' $
					   and not ps_options.a then begin
				i0=0
				cursor,x,y
				wait,1
				if !mouse.button eq 2 then i0=i
				if !mouse.button ne 1 then return
			endif
		endfor
		end
	 else   :print,'***Error(WW_PLOTOK): '+ $
			'choice not available!'
	 endcase
	 end
	 else   :print,'***Error(WW_PLOTOK): '+ $
			'choice not available!'
	 endcase
	 end
else    :print,'***Error(WW_PLOTOK): class unknown: ',class
endcase
;
if !d.name eq 'PS' then begin
	print,'Printed to file '+filename
	device,/close_file
	device,/portrait
	set_plot,!display
;	Deactivated in 2019, ps_options.s=1 now means "smoothing"
	if 0 then begin
	if ps_options.s then begin
	   if strpos(strupcase(getenv('HOST')),'tucana') ne -1 then begin
	      if ps_options.c then spawn,'lpr -h '+filename $
			      else spawn,'lpr -h '+filename
	   endif else begin
		if ps_options.c then spawn,'lpr -h -Pqmscolor '+filename $
		                else spawn,'lpr -h '+filename
	   endelse
	   print,'Plot submitted.'
	   wait,3
	   spawn,'rm -f '+filename
	endif else print,'Plot saved to: '+filename
	endif
endif
;
end
